/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.sniffer.document;

import com.google.inject.Singleton;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import network.oxalis.ng.api.lang.OxalisContentException;
import network.oxalis.ng.api.transformer.ContentDetector;
import network.oxalis.ng.api.util.Type;
import network.oxalis.ng.sniffer.PeppolStandardBusinessHeader;
import network.oxalis.ng.sniffer.document.HardCodedNamespaceResolver;
import network.oxalis.ng.sniffer.document.PlainUBLHeaderParser;
import network.oxalis.ng.sniffer.document.parsers.PEPPOLDocumentParser;
import network.oxalis.vefa.peppol.common.model.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@Singleton
@Type(value={"legacy"})
public class NoSbdhParser
implements ContentDetector {
    private static final Logger log = LoggerFactory.getLogger(NoSbdhParser.class);
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public NoSbdhParser() {
        log.warn("You have enabled support for automatic detection of content. This functionality will be turned of by default in version 4.1 and removed in version 4.2/5.0. Use configuration \"oxalis.transformer.detector = noop\" to disable it today.");
    }

    public Header parse(InputStream inputStream) throws OxalisContentException {
        return this.originalParse(inputStream).toVefa();
    }

    public PeppolStandardBusinessHeader originalParse(InputStream inputStream) throws OxalisContentException {
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(new HardCodedNamespaceResolver());
            PeppolStandardBusinessHeader sbdh = PeppolStandardBusinessHeader.createPeppolStandardBusinessHeaderWithNewDate();
            PlainUBLHeaderParser headerParser = new PlainUBLHeaderParser(document, xPath);
            if (headerParser.canParse()) {
                sbdh.setDocumentTypeIdentifier(headerParser.fetchDocumentTypeId().toVefa());
                sbdh.setProfileTypeIdentifier(headerParser.fetchProcessTypeId());
                PEPPOLDocumentParser documentParser = null;
                try {
                    documentParser = headerParser.createDocumentParser();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (documentParser != null) {
                    try {
                        sbdh.setSenderId(documentParser.getSender());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        sbdh.setRecipientId(documentParser.getReceiver());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return sbdh;
        }
        catch (Exception e) {
            throw new OxalisContentException("Unable to parseOld document " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to configure DOM parser for secure processing.", e);
        }
    }
}

