/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.mode;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.security.cert.X509Certificate;
import network.oxalis.vefa.peppol.common.code.Service;
import network.oxalis.vefa.peppol.security.api.CertificateValidator;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;

@Singleton
public class OxalisCertificateValidator
implements CertificateValidator {
    private CertificateValidator certificateValidator;
    private Tracer tracer;

    @Inject
    public OxalisCertificateValidator(CertificateValidator certificateValidator, Tracer tracer) {
        this.certificateValidator = certificateValidator;
        this.tracer = tracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(Service service, X509Certificate certificate) throws PeppolSecurityException {
        Span span = this.tracer.spanBuilder("Validate certificate").startSpan();
        try {
            span.setAttribute("subject", certificate.getSubjectX500Principal().toString());
            span.setAttribute("issuer", certificate.getIssuerX500Principal().toString());
            this.certificateValidator.validate(service, certificate);
        }
        finally {
            span.end();
        }
    }
}

