/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.as4.inbound;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.BindingType;
import jakarta.xml.ws.Provider;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.ServiceMode;
import jakarta.xml.ws.WebServiceContext;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.WebServiceProvider;
import jakarta.xml.ws.handler.MessageContext;
import network.oxalis.ng.as4.inbound.As4InboundHandler;
import network.oxalis.ng.as4.lang.OxalisAs4Exception;

@WebServiceProvider
@ServiceMode(value=Service.Mode.MESSAGE)
@BindingType(value="http://www.w3.org/2003/05/soap/bindings/HTTP/")
@Singleton
public class As4Provider
implements Provider<SOAPMessage> {
    @Resource
    private WebServiceContext context;
    @Inject
    private As4InboundHandler handler;

    @Override
    public SOAPMessage invoke(SOAPMessage request) {
        MessageContext messageContext = this.context.getMessageContext();
        HttpServletResponse httpRes = (HttpServletResponse)messageContext.get("HTTP.RESPONSE");
        httpRes.setStatus(200);
        try {
            return this.handler.handle(request, messageContext);
        }
        catch (OxalisAs4Exception e) {
            httpRes.setStatus(400);
            throw new WebServiceException(e);
        }
    }
}

