/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.filesystem.detector;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import network.oxalis.ng.api.filesystem.HomeDetector;
import network.oxalis.ng.api.util.Sort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Sort(value=4000)
public class UserHomeDetector
implements HomeDetector {
    private static final Logger log = LoggerFactory.getLogger(UserHomeDetector.class);

    @Override
    public File detect() {
        Path path = Paths.get(System.getProperty("user.home"), ".oxalis");
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        log.info("Using Oxalis folder relative to home folder: {}", (Object)path);
        return path.toFile();
    }
}

