/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils.validation;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.validation.W3CMultiSchemaFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.XMLValidationException;
import org.codehaus.stax2.validation.XMLValidationProblem;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

class Stax2ValidationUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(Stax2ValidationUtils.class);
    private static final String KEY = XMLValidationSchema.class.getName();
    private static final boolean HAS_WOODSTOX_5;
    private static final boolean HAS_WOODSTOX_6_2;
    private final Class<?> multiSchemaFactory;

    Stax2ValidationUtils() throws ClassNotFoundException {
        if (!HAS_WOODSTOX_5 && !HAS_WOODSTOX_6_2) {
            throw new RuntimeException("Could not load woodstox");
        }
        String className = "com.ctc.wstx.msv.W3CMultiSchemaFactory";
        if (HAS_WOODSTOX_5) {
            className = "org.apache.cxf.staxutils.validation.W3CMultiSchemaFactory";
        }
        this.multiSchemaFactory = ClassLoaderUtils.loadClass(className, this.getClass());
    }

    public boolean setupValidation(XMLStreamReader reader, Endpoint endpoint, ServiceInfo serviceInfo) throws XMLStreamException {
        XMLStreamReader effectiveReader = reader;
        if (effectiveReader instanceof DepthXMLStreamReader) {
            effectiveReader = ((DepthXMLStreamReader)reader).getReader();
        }
        XMLStreamReader2 reader2 = (XMLStreamReader2)effectiveReader;
        XMLValidationSchema vs = this.getValidator(endpoint, serviceInfo);
        if (vs == null) {
            return false;
        }
        reader2.setValidationProblemHandler(new ValidationProblemHandler(){

            @Override
            public void reportProblem(XMLValidationProblem problem) throws XMLValidationException {
                throw new Fault(new Message("READ_VALIDATION_ERROR", LOG, problem.getMessage()), Fault.FAULT_CODE_CLIENT);
            }
        });
        reader2.validateAgainst(vs);
        return true;
    }

    public boolean setupValidation(XMLStreamWriter writer, Endpoint endpoint, ServiceInfo serviceInfo) throws XMLStreamException {
        XMLStreamWriter2 writer2 = (XMLStreamWriter2)writer;
        XMLValidationSchema vs = this.getValidator(endpoint, serviceInfo);
        if (vs == null) {
            return false;
        }
        writer2.setValidationProblemHandler(new ValidationProblemHandler(){

            @Override
            public void reportProblem(XMLValidationProblem problem) throws XMLValidationException {
                throw new Fault(problem.getMessage(), LOG);
            }
        });
        writer2.validateAgainst(vs);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLValidationSchema getValidator(Endpoint endpoint, ServiceInfo serviceInfo) throws XMLStreamException {
        Endpoint endpoint2 = endpoint;
        synchronized (endpoint2) {
            XMLValidationSchema ret = (XMLValidationSchema)endpoint.get(KEY);
            if (ret == null) {
                if (endpoint.containsKey(KEY)) {
                    return null;
                }
                TreeMap<String, Source> sources = new TreeMap<String, Source>();
                for (SchemaInfo schemaInfo : serviceInfo.getSchemas()) {
                    XmlSchema sch = schemaInfo.getSchema();
                    String uri = sch.getTargetNamespace();
                    if ("http://www.w3.org/2001/XMLSchema".equals(uri)) continue;
                    if (sch.getTargetNamespace() == null && !sch.getExternals().isEmpty()) {
                        for (XmlSchemaExternal xmlSchemaExternal : sch.getExternals()) {
                            this.addSchema(sources, xmlSchemaExternal.getSchema(), this.getElement(xmlSchemaExternal.getSchema().getSourceURI()));
                        }
                        continue;
                    }
                    if (sch.getTargetNamespace() == null) {
                        throw new IllegalStateException("An Schema without imports must have a targetNamespace");
                    }
                    this.addSchema(sources, sch, schemaInfo.getElement());
                }
                try {
                    Method method = this.multiSchemaFactory.getMethod("createSchema", String.class, Map.class);
                    ret = (XMLValidationSchema)method.invoke(this.multiSchemaFactory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), null, sources);
                    endpoint.put(KEY, ret);
                }
                catch (Throwable t2) {
                    LOG.log(Level.INFO, "Problem loading schemas. Falling back to slower method.", ret);
                    endpoint.put(KEY, null);
                }
            }
            return ret;
        }
    }

    private void addSchema(Map<String, Source> sources, XmlSchema schema, Element element) throws XMLStreamException {
        String schemaSystemId = schema.getSourceURI();
        if (null == schemaSystemId) {
            schemaSystemId = schema.getTargetNamespace();
        }
        sources.put(schema.getTargetNamespace(), new DOMSource(element, schemaSystemId));
    }

    private Element getElement(String path) throws XMLStreamException {
        InputSource in = new InputSource(path);
        Document doc = StaxUtils.read(in);
        return doc.getDocumentElement();
    }

    static {
        boolean hasWoodstox5 = false;
        boolean hasWoodstox62 = false;
        try {
            new W3CMultiSchemaFactory();
            hasWoodstox5 = true;
        }
        catch (Throwable t2) {
            try {
                Class<?> multiSchemaFactory = ClassLoaderUtils.loadClass("com.ctc.wstx.msv.W3CMultiSchemaFactory", Stax2ValidationUtils.class);
                if (multiSchemaFactory != null) {
                    hasWoodstox62 = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        HAS_WOODSTOX_5 = hasWoodstox5;
        HAS_WOODSTOX_6_2 = hasWoodstox62;
    }
}

