/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import network.oxalis.vefa.peppol.common.model.ArgumentIdentifier;
import network.oxalis.vefa.peppol.common.model.C1CountryIdentifier;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.InstanceIdentifier;
import network.oxalis.vefa.peppol.common.model.InstanceType;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;

public class Header
implements Serializable {
    private static final long serialVersionUID = -7517561747468194479L;
    private ParticipantIdentifier sender;
    private ParticipantIdentifier receiver;
    private List<ParticipantIdentifier> copyReceiver = new ArrayList<ParticipantIdentifier>();
    private ProcessIdentifier process;
    private DocumentTypeIdentifier documentType;
    private C1CountryIdentifier c1CountryIdentifier;
    private InstanceIdentifier identifier;
    private InstanceType instanceType;
    private Date creationTimestamp;
    private Map<String, ArgumentIdentifier> arguments = new HashMap<String, ArgumentIdentifier>();

    public static Header newInstance() {
        return new Header();
    }

    public static Header of(ParticipantIdentifier sender, ParticipantIdentifier receiver, List<ParticipantIdentifier> cc, ProcessIdentifier process, DocumentTypeIdentifier documentType, C1CountryIdentifier c1CountryIdentifier, InstanceIdentifier identifier, InstanceType instanceType, Date creationTimestamp) {
        return new Header(sender, receiver, cc, process, documentType, c1CountryIdentifier, identifier, instanceType, creationTimestamp, null);
    }

    public static Header of(ParticipantIdentifier sender, ParticipantIdentifier receiver, ProcessIdentifier process, DocumentTypeIdentifier documentType, C1CountryIdentifier c1CountryIdentifier, InstanceIdentifier identifier, InstanceType instanceType, Date creationTimestamp) {
        return new Header(sender, receiver, new ArrayList<ParticipantIdentifier>(), process, documentType, c1CountryIdentifier, identifier, instanceType, creationTimestamp, null);
    }

    public static Header of(ParticipantIdentifier sender, ParticipantIdentifier receiver, ProcessIdentifier process, DocumentTypeIdentifier documentType) {
        return new Header(sender, receiver, new ArrayList<ParticipantIdentifier>(), process, documentType, null, null, null, null, null);
    }

    public Header() {
    }

    private Header(ParticipantIdentifier sender, ParticipantIdentifier receiver, List<ParticipantIdentifier> copyReceiver, ProcessIdentifier process, DocumentTypeIdentifier documentType, C1CountryIdentifier c1CountryIdentifier, InstanceIdentifier identifier, InstanceType instanceType, Date creationTimestamp, Map<String, ArgumentIdentifier> arguments) {
        this.sender = sender;
        this.receiver = receiver;
        this.copyReceiver = copyReceiver;
        this.process = process;
        this.documentType = documentType;
        this.c1CountryIdentifier = c1CountryIdentifier;
        this.identifier = identifier;
        this.instanceType = instanceType;
        this.creationTimestamp = creationTimestamp;
        this.arguments = arguments == null ? this.arguments : arguments;
    }

    public Header sender(ParticipantIdentifier sender) {
        return this.copy(h -> {
            h.sender = sender;
        });
    }

    public Header receiver(ParticipantIdentifier receiver) {
        return this.copy(h -> {
            h.receiver = receiver;
        });
    }

    public Header cc(ParticipantIdentifier cc) {
        return this.copy(h -> h.copyReceiver.add(cc));
    }

    public Header process(ProcessIdentifier process) {
        return this.copy(h -> {
            h.process = process;
        });
    }

    public Header documentType(DocumentTypeIdentifier documentType) {
        return this.copy(h -> {
            h.documentType = documentType;
        });
    }

    public Header c1CountryIdentifier(C1CountryIdentifier c1CountryIdentifier) {
        return this.copy(h -> {
            h.c1CountryIdentifier = c1CountryIdentifier;
        });
    }

    public Header identifier(InstanceIdentifier identifier) {
        return this.copy(h -> {
            h.identifier = identifier;
        });
    }

    public Header instanceType(InstanceType instanceType) {
        return this.copy(h -> {
            h.instanceType = instanceType;
        });
    }

    public Header creationTimestamp(Date creationTimestamp) {
        return this.copy(h -> {
            h.creationTimestamp = creationTimestamp;
        });
    }

    public Header argument(ArgumentIdentifier identifier) {
        return this.copy(h -> h.arguments.put(identifier.getKey(), identifier));
    }

    public Header arguments(List<ArgumentIdentifier> extras) {
        return this.copy(h -> extras.forEach(ai -> h.arguments.put(ai.getKey(), (ArgumentIdentifier)ai)));
    }

    public ArgumentIdentifier getArgument(String key) {
        return this.arguments.get(key);
    }

    public List<ArgumentIdentifier> getArguments() {
        return new ArrayList<ArgumentIdentifier>(this.arguments.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header header = (Header)o;
        return Objects.equals(this.sender, header.sender) && Objects.equals(this.receiver, header.receiver) && Objects.equals(this.process, header.process) && Objects.equals(this.documentType, header.documentType) && Objects.equals(this.c1CountryIdentifier, header.c1CountryIdentifier) && Objects.equals(this.identifier, header.identifier) && Objects.equals(this.instanceType, header.instanceType) && Objects.equals(this.creationTimestamp, header.creationTimestamp) && Objects.equals(this.arguments, header.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.sender, this.receiver, this.process, this.documentType, this.c1CountryIdentifier, this.identifier, this.instanceType, this.creationTimestamp, this.arguments);
    }

    public String toString() {
        return "Header{sender=" + String.valueOf(this.sender) + ", receiver=" + String.valueOf(this.receiver) + ", copyReceiver=" + String.valueOf(this.copyReceiver) + ", process=" + String.valueOf(this.process) + ", documentType=" + String.valueOf(this.documentType) + ", c1CountryIdentifier=" + String.valueOf(this.c1CountryIdentifier) + ", identifier=" + String.valueOf(this.identifier) + ", instanceType=" + String.valueOf(this.instanceType) + ", creationTimestamp=" + String.valueOf(this.creationTimestamp) + ", arguments=" + String.valueOf(this.arguments) + "}";
    }

    private Header copy(Consumer<Header> consumer) {
        Header header = new Header(this.sender, this.receiver, new ArrayList<ParticipantIdentifier>(this.copyReceiver), this.process, this.documentType, this.c1CountryIdentifier, this.identifier, this.instanceType, this.creationTimestamp, new HashMap<String, ArgumentIdentifier>(this.arguments));
        consumer.accept(header);
        return header;
    }

    public ParticipantIdentifier getSender() {
        return this.sender;
    }

    public ParticipantIdentifier getReceiver() {
        return this.receiver;
    }

    public List<ParticipantIdentifier> getCopyReceiver() {
        return this.copyReceiver;
    }

    public ProcessIdentifier getProcess() {
        return this.process;
    }

    public DocumentTypeIdentifier getDocumentType() {
        return this.documentType;
    }

    public C1CountryIdentifier getC1CountryIdentifier() {
        return this.c1CountryIdentifier;
    }

    public InstanceIdentifier getIdentifier() {
        return this.identifier;
    }

    public InstanceType getInstanceType() {
        return this.instanceType;
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }
}

