/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.statistics.security;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class OxalisCipher {
    public static final String SYMMETRIC_KEY_ALGORITHM = "AES";
    public static final String WRAPPED_SYMMETRIC_KEY_HEADER_NAME = "PEPPOL-wrapped-key";
    private SecretKey secretKey;

    public OxalisCipher() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(SYMMETRIC_KEY_ALGORITHM);
            this.secretKey = keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to create symmetric key for AES" + String.valueOf(e), e);
        }
    }

    public OxalisCipher(SecretKey secretKey) {
        this.secretKey = secretKey;
    }

    public OutputStream encryptStream(OutputStream outputStream) {
        Cipher cipher = this.createCipher(1);
        return new CipherOutputStream(outputStream, cipher);
    }

    public InputStream decryptStream(InputStream inputStream) {
        Cipher cipher = this.createCipher(2);
        return new CipherInputStream(inputStream, cipher);
    }

    Cipher createCipher(int encryptMode) {
        if (this.secretKey == null) {
            throw new IllegalStateException("No symmetric secret key available");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(SYMMETRIC_KEY_ALGORITHM);
            cipher.init(encryptMode, this.secretKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to create cipher for algorithm AES", e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalStateException("Default padding does not work with algorithm AES", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("Invalid AES key");
        }
        return cipher;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    byte[] encrypt(byte[] bytes) throws BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = this.createCipher(1);
        return cipher.doFinal(bytes);
    }

    byte[] decrypt(byte[] encryptedBytes) throws BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = this.createCipher(2);
        return cipher.doFinal(encryptedBytes);
    }
}

