/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import com.google.common.base.Functions;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.logic.Predicate;

public final class FunctionSupport {
    private FunctionSupport() {
    }

    @Nonnull
    public static <T1, T2> Function<T1, T2> constant(@Nullable @ParameterName(name="target") T2 target) {
        return Functions.constant(target);
    }

    @Nonnull
    public static <A, B, C> Function<A, C> compose(@Nonnull @ParameterName(name="g") Function<? super B, ? extends C> g2, @Nonnull @ParameterName(name="f") Function<A, ? extends B> f) {
        return f.andThen(g2);
    }

    @Nonnull
    public static <T> Function<T, Boolean> forPredicate(@Nonnull @ParameterName(name="predicate") Predicate<? super T> predicate) {
        return predicate::test;
    }
}

