/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import com.google.common.net.MediaType;
import java.util.Set;
import java.util.function.Function;
import net.shibboleth.utilities.java.support.net.StripMediaTypeParametersFunction;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public final class MediaTypeSupport {
    private static final Function<MediaType, MediaType> STRIP_PARAMS = new StripMediaTypeParametersFunction();

    private MediaTypeSupport() {
    }

    public static boolean validateContentType(String contentType, Set<MediaType> validTypes, boolean noContentTypeIsValid, boolean isOneOfStrategy) {
        String contentTypeValue = StringSupport.trimOrNull(contentType);
        if (contentTypeValue != null) {
            if (isOneOfStrategy) {
                MediaType mediaType = MediaType.parse(contentTypeValue);
                for (MediaType validType : validTypes) {
                    if (!mediaType.is(validType)) continue;
                    return true;
                }
                return false;
            }
            MediaType mediaType = MediaType.parse(contentTypeValue).withoutParameters();
            return validTypes.stream().map(STRIP_PARAMS).filter(t2 -> t2 != null).anyMatch(mediaType::equals);
        }
        return noContentTypeIsValid;
    }
}

