/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.persist;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import network.oxalis.ng.api.evidence.EvidenceFactory;
import network.oxalis.ng.api.inbound.InboundMetadata;
import network.oxalis.ng.api.lang.EvidenceException;
import network.oxalis.ng.api.model.TransmissionIdentifier;
import network.oxalis.ng.api.persist.PersisterHandler;
import network.oxalis.ng.api.util.Type;
import network.oxalis.ng.commons.filesystem.FileUtils;
import network.oxalis.ng.commons.persist.PersisterUtils;
import network.oxalis.vefa.peppol.common.model.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Type(value={"default"})
public class DefaultPersister
implements PersisterHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultPersister.class);
    private final EvidenceFactory evidenceFactory;
    private final Path inboundFolder;

    @Inject
    public DefaultPersister(@Named(value="inbound") Path inboundFolder, EvidenceFactory evidenceFactory) {
        this.inboundFolder = inboundFolder;
        this.evidenceFactory = evidenceFactory;
    }

    @Override
    public Path persist(TransmissionIdentifier transmissionIdentifier, Header header, InputStream inputStream) throws IOException {
        Path path = PersisterUtils.createArtifactFolders(this.inboundFolder, header).resolve(String.format("%s.doc.xml", FileUtils.filterString(transmissionIdentifier.getIdentifier())));
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            ByteStreams.copy(inputStream, outputStream);
        }
        log.debug("Payload persisted to: {}", (Object)path);
        return path;
    }

    @Override
    public void persist(InboundMetadata inboundMetadata, Path payloadPath) throws IOException {
        Path path = PersisterUtils.createArtifactFolders(this.inboundFolder, inboundMetadata.getHeader()).resolve(String.format("%s.receipt.dat", FileUtils.filterString(inboundMetadata.getTransmissionIdentifier().getIdentifier())));
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            this.evidenceFactory.write(outputStream, inboundMetadata);
        }
        catch (EvidenceException e) {
            throw new IOException("Unable to persist receipt.", e);
        }
        log.debug("Receipt persisted to: {}", (Object)path);
    }

    @Override
    public void persist(TransmissionIdentifier transmissionIdentifier, Header header, Path payloadPath, Exception exception) {
        try {
            log.warn("Transmission '{}' failed duo to {}.", (Object)transmissionIdentifier, (Object)exception.getMessage());
            Files.delete(payloadPath);
        }
        catch (IOException e) {
            log.warn("Unable to delete file: {}", (Object)payloadPath, (Object)e);
        }
    }
}

