/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.common.model;

import java.io.Serializable;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Objects;
import network.oxalis.vefa.peppol.common.api.SimpleEndpoint;
import network.oxalis.vefa.peppol.common.model.Period;
import network.oxalis.vefa.peppol.common.model.TransportProfile;

public class Endpoint
implements Serializable,
SimpleEndpoint {
    private static final long serialVersionUID = 5892469135654700883L;
    private final TransportProfile transportProfile;
    private final URI address;
    private final X509Certificate certificate;
    private final Period period;

    public static Endpoint of(TransportProfile transportProfile, URI address, X509Certificate certificate) {
        return new Endpoint(transportProfile, address, certificate, null);
    }

    public static Endpoint of(TransportProfile transportProfile, URI address, X509Certificate certificate, Period period) {
        return new Endpoint(transportProfile, address, certificate, period);
    }

    public Endpoint(TransportProfile transportProfile, URI address, X509Certificate certificate, Period period) {
        this.transportProfile = transportProfile;
        this.address = address;
        this.certificate = certificate;
        this.period = period;
    }

    @Override
    public TransportProfile getTransportProfile() {
        return this.transportProfile;
    }

    public URI getAddress() {
        return this.address;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public Period getPeriod() {
        return this.period;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return Objects.equals(this.transportProfile, endpoint.transportProfile) && Objects.equals(this.address, endpoint.address) && Objects.equals(this.certificate, endpoint.certificate) && Objects.equals(this.period, endpoint.period);
    }

    public int hashCode() {
        return Objects.hash(this.transportProfile, this.address, this.certificate, this.period);
    }

    public String toString() {
        return "Endpoint{transportProfile=" + String.valueOf(this.transportProfile) + ", address=" + String.valueOf(this.address) + ", certificate=" + String.valueOf(this.certificate) + ", period=" + String.valueOf(this.period) + "}";
    }
}

