/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.message;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.w3c.dom.Node;

public final class MessageUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(MessageUtils.class);

    private MessageUtils() {
    }

    public static boolean isOutbound(Message message) {
        if (message == null) {
            return false;
        }
        Exchange exchange = message.getExchange();
        return exchange != null && (message == exchange.getOutMessage() || message == exchange.getOutFaultMessage());
    }

    public static boolean isFault(Message message) {
        return message != null && message.getExchange() != null && (message == message.getExchange().getInFaultMessage() || message == message.getExchange().getOutFaultMessage());
    }

    public static FaultMode getFaultMode(Message message) {
        if (message != null && message.getExchange() != null && message == message.getExchange().getOutFaultMessage()) {
            FaultMode mode = message.get(FaultMode.class);
            if (null != mode) {
                return mode;
            }
            return FaultMode.RUNTIME_FAULT;
        }
        return null;
    }

    public static boolean isRequestor(Message message) {
        if (message != null) {
            Boolean requestor = (Boolean)message.get("org.apache.cxf.client");
            return requestor != null && requestor != false;
        }
        return false;
    }

    public static boolean isPartialResponse(Message message) {
        return message != null && Boolean.TRUE.equals(message.get("org.apache.cxf.partial.response"));
    }

    public static boolean isEmptyPartialResponse(Message message) {
        return message != null && Boolean.TRUE.equals(message.get("org.apache.cxf.partial.response.empty"));
    }

    @Deprecated
    public static boolean isTrue(Object value) {
        return PropertyUtils.isTrue(value);
    }

    public static boolean getContextualBoolean(Message m4, String key) {
        return MessageUtils.getContextualBoolean(m4, key, false);
    }

    public static boolean getContextualBoolean(Message m4, String key, boolean defaultValue) {
        Object o;
        if (m4 != null && (o = m4.getContextualProperty(key)) != null) {
            return PropertyUtils.isTrue(o);
        }
        return defaultValue;
    }

    public static Collection<Integer> getContextualIntegers(Message m4, String key, Collection<Integer> defaultValue) {
        Object o;
        if (m4 != null && (o = m4.getContextualProperty(key)) instanceof String) {
            ArrayList<Integer> intValues = new ArrayList<Integer>();
            for (String value : ((String)o).split(",")) {
                try {
                    if (StringUtils.isEmpty(value)) continue;
                    intValues.add(Integer.parseInt(value.trim()));
                }
                catch (NumberFormatException ex) {
                    LOG.warning("Incorrect integer value of " + value + " specified for: " + key);
                }
            }
            return intValues;
        }
        return defaultValue;
    }

    public static int getContextualInteger(Message m4, String key, int defaultValue) {
        Object o;
        if (m4 != null && (o = m4.getContextualProperty(key)) instanceof String) {
            try {
                int i = Integer.parseInt((String)o);
                if (i > 0) {
                    return i;
                }
            }
            catch (NumberFormatException ex) {
                LOG.warning("Incorrect integer value of " + o + " specified for: " + key);
            }
        }
        return defaultValue;
    }

    public static Set<String> getContextualStrings(Message m4, String key, Set<String> defaultValue) {
        Object o;
        if (m4 != null && (o = m4.getContextualProperty(key)) instanceof String) {
            TreeSet<String> values = new TreeSet<String>();
            for (String value : ((String)o).split(",")) {
                if (StringUtils.isEmpty(value)) continue;
                values.add(value.trim());
            }
            return values;
        }
        return defaultValue;
    }

    public static String getContextualString(Message m4, String key, String defaultValue) {
        if (m4 != null) {
            Object o = m4.getContextualProperty(key);
            if (o instanceof String) {
                return (String)o;
            }
            if (o != null) {
                return o.toString();
            }
        }
        return defaultValue;
    }

    public static Object getContextualProperty(Message m4, String propPreferred, String propDefault) {
        Object prop = null;
        if (m4 != null && (prop = m4.getContextualProperty(propPreferred)) == null && propDefault != null) {
            prop = m4.getContextualProperty(propDefault);
        }
        return prop;
    }

    public static boolean isDOMPresent(Message m4) {
        return m4 != null && m4.getContent(Node.class) != null;
    }

    public static Optional<Method> getTargetMethod(Message m4) {
        Method method;
        BindingOperationInfo bop = m4.getExchange().getBindingOperationInfo();
        if (bop != null) {
            MethodDispatcher md = (MethodDispatcher)m4.getExchange().getService().get(MethodDispatcher.class.getName());
            method = md.getMethod(bop);
        } else {
            method = (Method)m4.get("org.apache.cxf.resource.method");
        }
        return Optional.ofNullable(method);
    }

    public static int getReponseCodeFromMessage(Message message) {
        Integer i = (Integer)message.get(Message.RESPONSE_CODE);
        if (i != null) {
            return i;
        }
        int code = MessageUtils.hasNoResponseContent(message) ? 202 : 200;
        message.put(Message.RESPONSE_CODE, code);
        return code;
    }

    public static boolean hasNoResponseContent(Message message) {
        boolean ow = MessageUtils.isOneWay(message);
        boolean pr = MessageUtils.isPartialResponse(message);
        boolean epr = MessageUtils.isEmptyPartialResponse(message);
        return ow && !pr || epr;
    }

    public static boolean isOneWay(Message message) {
        Exchange ex = message.getExchange();
        return ex != null && ex.isOneWay();
    }
}

