/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertionBuilder;
import org.apache.cxf.ws.security.policy.custom.AlgorithmSuiteLoader;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.xml.XMLPrimitiveAssertionBuilder;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.w3c.dom.Element;

public class DefaultAlgorithmSuiteLoader
implements AlgorithmSuiteLoader {
    @Override
    public AlgorithmSuite getAlgorithmSuite(Bus bus, SPConstants.SPVersion version, Policy nestedPolicy) {
        AssertionBuilderRegistry reg = bus.getExtension(AssertionBuilderRegistry.class);
        if (reg != null) {
            String ns = "http://cxf.apache.org/custom/security-policy";
            final HashMap<QName, PrimitiveAssertion> assertions = new HashMap<QName, PrimitiveAssertion>();
            QName qName = new QName(ns, "Basic128GCM");
            assertions.put(qName, new PrimitiveAssertion(qName));
            qName = new QName(ns, "Basic192GCM");
            assertions.put(qName, new PrimitiveAssertion(qName));
            qName = new QName(ns, "Basic256GCM");
            assertions.put(qName, new PrimitiveAssertion(qName));
            qName = new QName(ns, "CustomAlgorithmSuite");
            assertions.put(qName, new PrimitiveAssertion(qName));
            reg.registerBuilder(new PrimitiveAssertionBuilder(assertions.keySet()){

                @Override
                public Assertion build(Element element, AssertionBuilderFactory fact) {
                    if (XMLPrimitiveAssertionBuilder.isOptional(element) || XMLPrimitiveAssertionBuilder.isIgnorable(element)) {
                        return super.build(element, fact);
                    }
                    QName q = new QName(element.getNamespaceURI(), element.getLocalName());
                    return (Assertion)assertions.get(q);
                }
            });
        }
        return new GCMAlgorithmSuite(version, nestedPolicy);
    }

    public static AlgorithmSuite.AlgorithmSuiteType customize(AlgorithmSuite.AlgorithmSuiteType suiteType, Message message) {
        Map<String, Object> values = message.getContextualPropertyKeys().stream().filter(k -> k.startsWith("ws-security.custom.alg.suite.")).collect(Collectors.toMap(Function.identity(), k -> message.getContextualProperty((String)k)));
        return DefaultAlgorithmSuiteLoader.customize(suiteType, values);
    }

    public static AlgorithmSuite.AlgorithmSuiteType customize(AlgorithmSuite.AlgorithmSuiteType suiteType, Map<String, Object> values) {
        if (suiteType == null || suiteType != null && !"CustomAlgorithmSuite".equals(suiteType.getName())) {
            return suiteType;
        }
        AlgorithmSuite.AlgorithmSuiteType retVal = suiteType;
        if (values == null || values.isEmpty()) {
            return retVal;
        }
        DefaultAlgorithmSuiteLoader.customizeAlgSuiteType(retVal, suiteType, values);
        return retVal;
    }

    private static void customizeAlgSuiteType(AlgorithmSuite.AlgorithmSuiteType suiteType, AlgorithmSuite.AlgorithmSuiteType defValue, Map<String, Object> values) {
        DefaultAlgorithmSuiteLoader.setValue("ws-security.custom.alg.suite.digest.algorithm", values, suiteType::setDigest, defValue != null ? defValue::getDigest : null);
        DefaultAlgorithmSuiteLoader.setValue("ws-security.custom.alg.suite.encryption.algorithm", values, suiteType::setEncryption, defValue != null ? defValue::getEncryption : null);
        DefaultAlgorithmSuiteLoader.setValue("ws-security.custom.alg.suite.symmetric.key.encryption.algorithm", values, suiteType::setSymmetricKeyWrap, defValue != null ? defValue::getSymmetricKeyWrap : null);
        DefaultAlgorithmSuiteLoader.setValue("ws-security.custom.alg.suite.asymmetric.key.encryption.algorithm", values, suiteType::setAsymmetricKeyWrap, defValue != null ? defValue::getAsymmetricKeyWrap : null);
        DefaultAlgorithmSuiteLoader.setValue("ws-security.custom.alg.suite.encryption.key.derivation", values, suiteType::setEncryptionKeyDerivation, defValue != null ? defValue::getEncryptionKeyDerivation : null);
        DefaultAlgorithmSuiteLoader.setValue("ws-security.custom.alg.suite.signature.key.derivation", values, suiteType::setSignatureKeyDerivation, defValue != null ? defValue::getSignatureKeyDerivation : null);
        DefaultAlgorithmSuiteLoader.setValue("ws-security.custom.alg.suite.symmetric.signature", values, suiteType::setSymmetricSignature, defValue != null ? defValue::getSymmetricSignature : null);
        DefaultAlgorithmSuiteLoader.setValue("ws-security.custom.alg.suite.asymmetric.signature", values, suiteType::setAsymmetricSignature, defValue != null ? defValue::getAsymmetricSignature : null);
        DefaultAlgorithmSuiteLoader.setValue("ws-security.custom.alg.suite.encryption.derived.key.length", values, suiteType::getEncryptionDerivedKeyLength, defValue != null ? defValue::getEncryptionDerivedKeyLength : null);
        DefaultAlgorithmSuiteLoader.setValue("ws-security.custom.alg.suite.signature.derived.key.length", values, suiteType::setSignatureDerivedKeyLength, defValue != null ? defValue::getSignatureDerivedKeyLength : null);
        DefaultAlgorithmSuiteLoader.setValue("ws-security.custom.alg.suite.minimum.symmetric.key.length", values, suiteType::setMinimumSymmetricKeyLength, defValue != null ? defValue::getMinimumSymmetricKeyLength : null);
        DefaultAlgorithmSuiteLoader.setValue("ws-security.custom.alg.suite.maximum.symmetric.key.length", values, suiteType::setMaximumSymmetricKeyLength, defValue != null ? defValue::getMaximumSymmetricKeyLength : null);
        DefaultAlgorithmSuiteLoader.setValue("ws-security.custom.alg.suite.minimum.asymmetric.key.length", values, suiteType::setMinimumAsymmetricKeyLength, defValue != null ? defValue::getMinimumAsymmetricKeyLength : null);
        DefaultAlgorithmSuiteLoader.setValue("ws-security.custom.alg.suite.maximum.asymmetric.key.length", values, suiteType::setMaximumAsymmetricKeyLength, defValue != null ? defValue::getMaximumAsymmetricKeyLength : null);
    }

    private static <T> void setValue(String key, Map<String, Object> values, Consumer<T> customValueSetter, Supplier<T> defaultValueGetter) {
        Object value = values.get(key);
        if (value == null && defaultValueGetter != null) {
            value = defaultValueGetter.get();
        }
        if (value != null) {
            customValueSetter.accept(value);
        }
    }

    public static class GCMAlgorithmSuite
    extends AlgorithmSuite {
        GCMAlgorithmSuite(SPConstants.SPVersion version, Policy nestedPolicy) {
            super(version, nestedPolicy);
        }

        @Override
        protected AbstractSecurityAssertion cloneAssertion(Policy nestedPolicy) {
            return new GCMAlgorithmSuite(this.getVersion(), nestedPolicy);
        }

        @Override
        protected void parseCustomAssertion(Assertion assertion) {
            String assertionName = assertion.getName().getLocalPart();
            String assertionNamespace = assertion.getName().getNamespaceURI();
            if (!"http://cxf.apache.org/custom/security-policy".equals(assertionNamespace)) {
                return;
            }
            if ("Basic128GCM".equals(assertionName)) {
                this.setAlgorithmSuiteType((AlgorithmSuite.AlgorithmSuiteType)ALGORITHM_SUITE_TYPES.get("Basic128GCM"));
                this.getAlgorithmSuiteType().setNamespace(assertionNamespace);
            } else if ("Basic192GCM".equals(assertionName)) {
                this.setAlgorithmSuiteType((AlgorithmSuite.AlgorithmSuiteType)ALGORITHM_SUITE_TYPES.get("Basic192GCM"));
                this.getAlgorithmSuiteType().setNamespace(assertionNamespace);
            } else if ("Basic256GCM".equals(assertionName)) {
                this.setAlgorithmSuiteType((AlgorithmSuite.AlgorithmSuiteType)ALGORITHM_SUITE_TYPES.get("Basic256GCM"));
                this.getAlgorithmSuiteType().setNamespace(assertionNamespace);
            } else if ("CustomAlgorithmSuite".equals(assertionName)) {
                this.setAlgorithmSuiteType((AlgorithmSuite.AlgorithmSuiteType)ALGORITHM_SUITE_TYPES.get("CustomAlgorithmSuite"));
                this.getAlgorithmSuiteType().setNamespace(assertionNamespace);
            }
        }

        static {
            ALGORITHM_SUITE_TYPES.put("Basic128GCM", new AlgorithmSuite.AlgorithmSuiteType("Basic128GCM", "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2009/xmlenc11#aes128-gcm", "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 128, 128, 128, 256, 1024, 4096));
            ALGORITHM_SUITE_TYPES.put("Basic192GCM", new AlgorithmSuite.AlgorithmSuiteType("Basic192GCM", "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2009/xmlenc11#aes192-gcm", "http://www.w3.org/2001/04/xmlenc#kw-aes192", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 192, 192, 192, 256, 1024, 4096));
            ALGORITHM_SUITE_TYPES.put("Basic256GCM", new AlgorithmSuite.AlgorithmSuiteType("Basic256GCM", "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2009/xmlenc11#aes256-gcm", "http://www.w3.org/2001/04/xmlenc#kw-aes256", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 256, 192, 256, 256, 1024, 4096));
            ALGORITHM_SUITE_TYPES.put("CustomAlgorithmSuite", new AlgorithmSuite.AlgorithmSuiteType("CustomAlgorithmSuite", "http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2009/xmlenc11#aes256-gcm", "http://www.w3.org/2001/04/xmlenc#kw-aes256", "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1", 256, 192, 256, 256, 1024, 4096));
        }
    }
}

