/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.FluentCacheConfigurationBuilder;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.config.ExpiryUtils;
import org.ehcache.expiry.Expiry;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.impl.config.BaseCacheConfiguration;
import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.impl.config.event.DefaultCacheEventDispatcherConfiguration;
import org.ehcache.impl.config.event.DefaultCacheEventListenerConfiguration;
import org.ehcache.impl.config.event.DefaultEventSourceConfiguration;
import org.ehcache.impl.config.loaderwriter.DefaultCacheLoaderWriterConfiguration;
import org.ehcache.impl.config.resilience.DefaultResilienceStrategyConfiguration;
import org.ehcache.impl.config.serializer.DefaultSerializerConfiguration;
import org.ehcache.impl.config.store.disk.OffHeapDiskStoreConfiguration;
import org.ehcache.impl.config.store.heap.DefaultSizeOfEngineConfiguration;
import org.ehcache.impl.copy.SerializingCopier;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.resilience.ResilienceStrategy;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.ServiceConfiguration;

public class CacheConfigurationBuilder<K, V>
implements FluentCacheConfigurationBuilder<K, V, CacheConfigurationBuilder<K, V>> {
    private final Collection<ServiceConfiguration<?, ?>> serviceConfigurations = new HashSet();
    private ExpiryPolicy<? super K, ? super V> expiry;
    private ClassLoader classLoader = null;
    private EvictionAdvisor<? super K, ? super V> evictionAdvisor;
    private ResourcePools resourcePools;
    private final Class<K> keyType;
    private final Class<V> valueType;

    public static <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilder(Class<K> keyType, Class<V> valueType, ResourcePools resourcePools) {
        return new CacheConfigurationBuilder<K, V>(keyType, valueType, resourcePools);
    }

    public static <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilder(Class<K> keyType, Class<V> valueType, Builder<? extends ResourcePools> resourcePoolsBuilder) {
        return new CacheConfigurationBuilder<K, V>(keyType, valueType, resourcePoolsBuilder.build());
    }

    public static <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilder(CacheConfiguration<K, V> configuration) {
        FluentCacheConfigurationBuilder builder = ((CacheConfigurationBuilder)CacheConfigurationBuilder.newCacheConfigurationBuilder(configuration.getKeyType(), configuration.getValueType(), configuration.getResourcePools()).withEvictionAdvisor((EvictionAdvisor)configuration.getEvictionAdvisor())).withExpiry(configuration.getExpiryPolicy());
        ClassLoader classLoader = configuration.getClassLoader();
        if (classLoader != null) {
            builder = ((CacheConfigurationBuilder)builder).withClassLoader(classLoader);
        }
        for (ServiceConfiguration<?, ?> serviceConfig : configuration.getServiceConfigurations()) {
            builder = ((CacheConfigurationBuilder)builder).withService((ServiceConfiguration)serviceConfig);
        }
        return builder;
    }

    private CacheConfigurationBuilder(Class<K> keyType, Class<V> valueType, ResourcePools resourcePools) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.resourcePools = resourcePools;
    }

    private CacheConfigurationBuilder(CacheConfigurationBuilder<K, V> other) {
        this.keyType = other.keyType;
        this.valueType = other.valueType;
        this.expiry = other.expiry;
        this.classLoader = other.classLoader;
        this.evictionAdvisor = other.evictionAdvisor;
        this.resourcePools = other.resourcePools;
        this.serviceConfigurations.addAll(other.serviceConfigurations);
    }

    @Deprecated
    public CacheConfigurationBuilder<K, V> add(ServiceConfiguration<?, ?> configuration) {
        if (!this.getServices(configuration.getClass()).isEmpty()) {
            if (configuration instanceof DefaultCopierConfiguration || configuration instanceof DefaultSerializerConfiguration || configuration instanceof DefaultCacheEventListenerConfiguration) {
                return this.withService((ServiceConfiguration)configuration);
            }
            throw new IllegalStateException("Cannot add a generic service configuration when another one already exists. Rely on specific with* methods or make sure your remove other configuration first.");
        }
        return this.withService((ServiceConfiguration)configuration);
    }

    @Deprecated
    public CacheConfigurationBuilder<K, V> add(Builder<? extends ServiceConfiguration<?, ?>> configurationBuilder) {
        return this.add(configurationBuilder.build());
    }

    @Override
    public <C extends ServiceConfiguration<?, ?>> Collection<C> getServices(Class<C> configurationType) throws IllegalArgumentException {
        return this.serviceConfigurations.stream().filter(configurationType::isInstance).map(configurationType::cast).collect(Collectors.toList());
    }

    @Override
    public CacheConfigurationBuilder<K, V> withService(ServiceConfiguration<?, ?> config) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.serviceConfigurations.removeIf(other -> !other.compatibleWith(config) || !config.compatibleWith((ServiceConfiguration<?, ?>)other));
        otherBuilder.serviceConfigurations.add(config);
        return otherBuilder;
    }

    @Override
    public CacheConfigurationBuilder<K, V> withoutServices(Class<? extends ServiceConfiguration<?, ?>> clazz) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.serviceConfigurations.removeIf(clazz::isInstance);
        return otherBuilder;
    }

    @Override
    public <C extends ServiceConfiguration<?, ?>> CacheConfigurationBuilder<K, V> withoutServices(Class<C> clazz, Predicate<? super C> predicate) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.serviceConfigurations.removeIf(c -> clazz.isInstance(c) && predicate.test((Object)clazz.cast(c)));
        return otherBuilder;
    }

    @Override
    public <R, C extends ServiceConfiguration<?, R>> CacheConfigurationBuilder<K, V> updateServices(Class<C> clazz, UnaryOperator<R> update2) {
        Collection<C> existing = this.getServices(clazz);
        if (existing.isEmpty()) {
            throw new IllegalStateException("Cannot update service configurations. No existing services of type: " + clazz);
        }
        FluentCacheConfigurationBuilder otherBuilder = this.withoutServices(clazz);
        for (ServiceConfiguration configuration : existing) {
            ServiceConfiguration replacement = configuration.build(update2.apply(configuration.derive()));
            if (replacement == null) {
                throw new NullPointerException(configuration.getClass().getSimpleName() + ".build(...) returned a null configuration instance");
            }
            otherBuilder = ((CacheConfigurationBuilder)otherBuilder).withService(replacement);
        }
        return otherBuilder;
    }

    @Override
    public CacheConfigurationBuilder<K, V> withEvictionAdvisor(EvictionAdvisor<? super K, ? super V> evictionAdvisor) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.evictionAdvisor = evictionAdvisor;
        return otherBuilder;
    }

    @Deprecated
    public CacheConfigurationBuilder<K, V> remove(ServiceConfiguration<?, ?> configuration) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.serviceConfigurations.remove(configuration);
        return otherBuilder;
    }

    @Deprecated
    public CacheConfigurationBuilder<K, V> clearAllServiceConfig() {
        return this.withoutServices(ServiceConfiguration.class);
    }

    @Deprecated
    public <T extends ServiceConfiguration<?, ?>> T getExistingServiceConfiguration(Class<T> clazz) {
        Iterator<T> iterator = this.getServices(clazz).iterator();
        return (T)(iterator.hasNext() ? (ServiceConfiguration)iterator.next() : null);
    }

    @Deprecated
    public <T extends ServiceConfiguration<?, ?>> List<T> getExistingServiceConfigurations(Class<T> clazz) {
        return new ArrayList<T>(this.getServices(clazz));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withClassLoader(ClassLoader classLoader) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.classLoader = Objects.requireNonNull(classLoader);
        return otherBuilder;
    }

    @Override
    public CacheConfigurationBuilder<K, V> withDefaultClassLoader() {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.classLoader = null;
        return otherBuilder;
    }

    @Override
    public CacheConfigurationBuilder<K, V> withResourcePools(ResourcePools resourcePools) {
        if (resourcePools == null) {
            throw new NullPointerException("Null resource pools");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.resourcePools = resourcePools;
        return otherBuilder;
    }

    @Override
    public CacheConfigurationBuilder<K, V> updateResourcePools(UnaryOperator<ResourcePools> update2) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.resourcePools = (ResourcePools)update2.apply(this.resourcePools);
        return otherBuilder;
    }

    @Override
    @Deprecated
    public CacheConfigurationBuilder<K, V> withExpiry(Expiry<? super K, ? super V> expiry) {
        return this.withExpiry((ExpiryPolicy)ExpiryUtils.convertToExpiryPolicy(Objects.requireNonNull(expiry, "Null expiry")));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withExpiry(ExpiryPolicy<? super K, ? super V> expiry) {
        if (expiry == null) {
            throw new NullPointerException("Null expiry");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.expiry = expiry;
        return otherBuilder;
    }

    public boolean hasConfiguredExpiry() {
        return this.expiry != null;
    }

    @Override
    public CacheConfigurationBuilder<K, V> withLoaderWriter(CacheLoaderWriter<K, V> loaderWriter) {
        return this.withService((ServiceConfiguration)new DefaultCacheLoaderWriterConfiguration(Objects.requireNonNull(loaderWriter, "Null loaderWriter")));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withLoaderWriter(Class<CacheLoaderWriter<K, V>> loaderWriterClass, Object ... arguments) {
        return this.withService((ServiceConfiguration)new DefaultCacheLoaderWriterConfiguration((Class<? extends CacheLoaderWriter<?, ?>>)Objects.requireNonNull(loaderWriterClass, "Null loaderWriterClass"), arguments));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withoutLoaderWriter() {
        return this.withoutServices(DefaultCacheLoaderWriterConfiguration.class);
    }

    @Override
    public CacheConfigurationBuilder<K, V> withResilienceStrategy(ResilienceStrategy<K, V> resilienceStrategy) {
        return this.withService((ServiceConfiguration)new DefaultResilienceStrategyConfiguration(Objects.requireNonNull(resilienceStrategy, "Null resilienceStrategy")));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withResilienceStrategy(Class<? extends ResilienceStrategy> resilienceStrategyClass, Object ... arguments) {
        return this.withService((ServiceConfiguration)new DefaultResilienceStrategyConfiguration(Objects.requireNonNull(resilienceStrategyClass, "Null resilienceStrategyClass"), arguments));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withDefaultResilienceStrategy() {
        return this.withoutServices(DefaultResilienceStrategyConfiguration.class);
    }

    @Override
    public CacheConfigurationBuilder<K, V> withKeySerializingCopier() {
        return this.withKeyCopier(SerializingCopier.asCopierClass());
    }

    @Override
    public CacheConfigurationBuilder<K, V> withValueSerializingCopier() {
        return this.withValueCopier(SerializingCopier.asCopierClass());
    }

    @Override
    public CacheConfigurationBuilder<K, V> withKeyCopier(Copier<K> keyCopier) {
        return this.withService(new DefaultCopierConfiguration<K>(Objects.requireNonNull(keyCopier, "Null key copier"), DefaultCopierConfiguration.Type.KEY));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withKeyCopier(Class<? extends Copier<K>> keyCopierClass) {
        return this.withService((ServiceConfiguration)new DefaultCopierConfiguration(Objects.requireNonNull(keyCopierClass, "Null key copier class"), DefaultCopierConfiguration.Type.KEY));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withoutKeyCopier() {
        return this.withoutServices(DefaultCopierConfiguration.class, (T c) -> DefaultCopierConfiguration.Type.KEY.equals((Object)c.getType()));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withValueCopier(Copier<V> valueCopier) {
        return this.withService(new DefaultCopierConfiguration<V>(Objects.requireNonNull(valueCopier, "Null value copier"), DefaultCopierConfiguration.Type.VALUE));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withValueCopier(Class<? extends Copier<V>> valueCopierClass) {
        return this.withService((ServiceConfiguration)new DefaultCopierConfiguration(Objects.requireNonNull(valueCopierClass, "Null value copier class"), DefaultCopierConfiguration.Type.VALUE));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withoutValueCopier() {
        return this.withoutServices(DefaultCopierConfiguration.class, (T c) -> DefaultCopierConfiguration.Type.VALUE.equals((Object)c.getType()));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withKeySerializer(Serializer<K> keySerializer) {
        return this.withService(new DefaultSerializerConfiguration<K>(Objects.requireNonNull(keySerializer, "Null key serializer"), DefaultSerializerConfiguration.Type.KEY));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withKeySerializer(Class<? extends Serializer<K>> keySerializerClass) {
        return this.withService((ServiceConfiguration)new DefaultSerializerConfiguration(Objects.requireNonNull(keySerializerClass, "Null key serializer class"), DefaultSerializerConfiguration.Type.KEY));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withDefaultKeySerializer() {
        return this.withoutServices(DefaultSerializerConfiguration.class, (T config) -> DefaultSerializerConfiguration.Type.KEY.equals((Object)config.getType()));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withValueSerializer(Serializer<V> valueSerializer) {
        return this.withService(new DefaultSerializerConfiguration<V>(Objects.requireNonNull(valueSerializer, "Null value serializer"), DefaultSerializerConfiguration.Type.VALUE));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withValueSerializer(Class<? extends Serializer<V>> valueSerializerClass) {
        return this.withService((ServiceConfiguration)new DefaultSerializerConfiguration(Objects.requireNonNull(valueSerializerClass, "Null value serializer class"), DefaultSerializerConfiguration.Type.VALUE));
    }

    @Override
    public CacheConfigurationBuilder<K, V> withDefaultValueSerializer() {
        return this.withoutServices(DefaultSerializerConfiguration.class, (T config) -> DefaultSerializerConfiguration.Type.VALUE.equals((Object)config.getType()));
    }

    public CacheConfigurationBuilder<K, V> withDispatcherConcurrency(int dispatcherConcurrency) {
        return this.withService((ServiceConfiguration)new DefaultEventSourceConfiguration(dispatcherConcurrency));
    }

    public CacheConfigurationBuilder<K, V> withDefaultDispatcherConcurrency() {
        return this.withoutServices(DefaultEventSourceConfiguration.class);
    }

    public CacheConfigurationBuilder<K, V> withEventListenersThreadPool(String threadPoolAlias) {
        return this.withService((ServiceConfiguration)new DefaultCacheEventDispatcherConfiguration(threadPoolAlias));
    }

    public CacheConfigurationBuilder<K, V> withDefaultEventListenersThreadPool() {
        return this.withoutServices(DefaultCacheEventDispatcherConfiguration.class);
    }

    public CacheConfigurationBuilder<K, V> withDiskStoreThreadPool(String threadPoolAlias, int concurrency) {
        return this.installOrUpdate(() -> new OffHeapDiskStoreConfiguration(threadPoolAlias, concurrency), existing -> new OffHeapDiskStoreConfiguration(threadPoolAlias, concurrency, existing.getDiskSegments()));
    }

    public CacheConfigurationBuilder<K, V> withDefaultDiskStoreThreadPool() {
        return this.withoutServices(OffHeapDiskStoreConfiguration.class);
    }

    @Deprecated
    public CacheConfigurationBuilder<K, V> withSizeOfMaxObjectGraph(long size) {
        return this.installOrUpdate(() -> new DefaultSizeOfEngineConfiguration(Long.MAX_VALUE, DefaultSizeOfEngineConfiguration.DEFAULT_UNIT, size), existing -> new DefaultSizeOfEngineConfiguration(existing.getMaxObjectSize(), existing.getUnit(), size));
    }

    @Deprecated
    public CacheConfigurationBuilder<K, V> withSizeOfMaxObjectSize(long size, MemoryUnit unit) {
        return this.installOrUpdate(() -> new DefaultSizeOfEngineConfiguration(size, unit, 1000L), existing -> new DefaultSizeOfEngineConfiguration(size, unit, existing.getMaxObjectGraphSize()));
    }

    @Deprecated
    public CacheConfigurationBuilder<K, V> withDefaultSizeOfSettings() {
        return this.withoutServices(DefaultSizeOfEngineConfiguration.class);
    }

    @Override
    public CacheConfiguration<K, V> build() {
        return new BaseCacheConfiguration<K, V>(this.keyType, this.valueType, this.evictionAdvisor, this.classLoader, this.expiry, this.resourcePools, this.serviceConfigurations.toArray(new ServiceConfiguration[this.serviceConfigurations.size()]));
    }

    private <R, C extends ServiceConfiguration<?, R>> CacheConfigurationBuilder<K, V> installOrUpdate(Supplier<C> supplier, UnaryOperator<R> update2) {
        ServiceConfiguration newConfig = (ServiceConfiguration)supplier.get();
        Class<?> configType = newConfig.getClass();
        if (this.getServices(configType).isEmpty()) {
            return this.withService(newConfig);
        }
        return this.updateServices(configType, (UnaryOperator)update2);
    }
}

