/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core;

import org.slf4j.Logger;
import org.slf4j.Marker;

class PrefixLogger
implements Logger {
    private final Logger delegate;
    private final String prefix;
    private final String formatEscapedPrefix;

    public PrefixLogger(Logger logger, String prefix) {
        this.delegate = logger;
        this.prefix = prefix;
        this.formatEscapedPrefix = this.formatEscape(prefix);
    }

    private String formatEscape(String string) {
        return string.replace("\\{}", "\\'{''}'").replace("{}", "\\{}");
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        this.delegate.trace(this.prefix + msg);
    }

    @Override
    public void trace(String format, Object arg) {
        this.delegate.trace(this.formatEscapedPrefix + format, arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.delegate.trace(this.formatEscapedPrefix + format, arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.delegate.trace(this.formatEscapedPrefix + format, arguments);
    }

    @Override
    public void trace(String msg, Throwable t2) {
        this.delegate.trace(this.prefix + msg, t2);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.delegate.isTraceEnabled(marker);
    }

    @Override
    public void trace(Marker marker, String msg) {
        this.delegate.trace(marker, this.prefix + msg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        this.delegate.trace(marker, this.formatEscapedPrefix + format, arg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.trace(marker, this.formatEscapedPrefix + format, arg1, arg2);
    }

    @Override
    public void trace(Marker marker, String format, Object ... argArray) {
        this.delegate.trace(marker, this.formatEscapedPrefix + format, argArray);
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t2) {
        this.delegate.trace(marker, this.prefix + msg, t2);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        this.delegate.debug(this.prefix + msg);
    }

    @Override
    public void debug(String format, Object arg) {
        this.delegate.debug(this.formatEscapedPrefix + format, arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.delegate.debug(this.formatEscapedPrefix + format, arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.delegate.debug(this.formatEscapedPrefix + format, arguments);
    }

    @Override
    public void debug(String msg, Throwable t2) {
        this.delegate.debug(this.prefix + msg, t2);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.delegate.isDebugEnabled(marker);
    }

    @Override
    public void debug(Marker marker, String msg) {
        this.delegate.debug(marker, this.prefix + msg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        this.delegate.debug(marker, this.formatEscapedPrefix + format, arg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.debug(marker, this.formatEscapedPrefix + format, arg1, arg2);
    }

    @Override
    public void debug(Marker marker, String format, Object ... arguments) {
        this.delegate.debug(marker, this.formatEscapedPrefix + format, arguments);
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t2) {
        this.delegate.debug(marker, this.prefix + msg, t2);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        this.delegate.info(this.prefix + msg);
    }

    @Override
    public void info(String format, Object arg) {
        this.delegate.info(this.formatEscapedPrefix + format, arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.delegate.info(this.formatEscapedPrefix + format, arg1, arg2);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.delegate.info(this.formatEscapedPrefix + format, arguments);
    }

    @Override
    public void info(String msg, Throwable t2) {
        this.delegate.info(this.prefix + msg, t2);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.delegate.isInfoEnabled(marker);
    }

    @Override
    public void info(Marker marker, String msg) {
        this.delegate.info(marker, this.prefix + msg);
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        this.delegate.info(marker, this.formatEscapedPrefix + format, arg);
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.info(marker, this.formatEscapedPrefix + format, arg1, arg2);
    }

    @Override
    public void info(Marker marker, String format, Object ... arguments) {
        this.delegate.info(marker, this.formatEscapedPrefix + format, arguments);
    }

    @Override
    public void info(Marker marker, String msg, Throwable t2) {
        this.delegate.info(marker, this.prefix + msg, t2);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        this.delegate.warn(this.prefix + msg);
    }

    @Override
    public void warn(String format, Object arg) {
        this.delegate.warn(this.formatEscapedPrefix + format, arg);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.delegate.warn(this.formatEscapedPrefix + format, arguments);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.delegate.warn(this.formatEscapedPrefix + format, arg1, arg2);
    }

    @Override
    public void warn(String msg, Throwable t2) {
        this.delegate.warn(this.prefix + msg, t2);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    @Override
    public void warn(Marker marker, String msg) {
        this.delegate.warn(marker, this.prefix + msg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        this.delegate.warn(marker, this.formatEscapedPrefix + format, arg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.warn(marker, this.formatEscapedPrefix + format, arg1, arg2);
    }

    @Override
    public void warn(Marker marker, String format, Object ... arguments) {
        this.delegate.warn(marker, this.formatEscapedPrefix + format, arguments);
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t2) {
        this.delegate.warn(marker, this.prefix + msg, t2);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    @Override
    public void error(String msg) {
        this.delegate.error(this.prefix + msg);
    }

    @Override
    public void error(String format, Object arg) {
        this.delegate.error(this.formatEscapedPrefix + format, arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.delegate.error(this.formatEscapedPrefix + format, arg1, arg2);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.delegate.error(this.formatEscapedPrefix + format, arguments);
    }

    @Override
    public void error(String msg, Throwable t2) {
        this.delegate.error(this.prefix + msg, t2);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.delegate.isErrorEnabled(marker);
    }

    @Override
    public void error(Marker marker, String msg) {
        this.delegate.error(marker, this.prefix + msg);
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        this.delegate.error(marker, this.formatEscapedPrefix + format, arg);
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.error(marker, this.formatEscapedPrefix + format, arg1, arg2);
    }

    @Override
    public void error(Marker marker, String format, Object ... arguments) {
        this.delegate.error(marker, this.formatEscapedPrefix + format, arguments);
    }

    @Override
    public void error(Marker marker, String msg, Throwable t2) {
        this.delegate.error(marker, this.prefix + msg, t2);
    }
}

