/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.executor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

class PartitionedUnorderedExecutor
extends AbstractExecutorService {
    private final BlockingQueue<Runnable> queue;
    private final ExecutorService executor;
    private final Semaphore runnerPermit;
    private final Set<Thread> liveThreads;
    private final int maxWorkers;
    private final CountDownLatch termination = new CountDownLatch(1);
    private volatile boolean shutdown;

    PartitionedUnorderedExecutor(BlockingQueue<Runnable> queue, ExecutorService executor, int maxWorkers) {
        this.queue = queue;
        this.executor = executor;
        this.maxWorkers = maxWorkers;
        this.runnerPermit = new Semaphore(maxWorkers);
        this.liveThreads = new CopyOnWriteArraySet<Thread>();
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        if (this.isTerminated()) {
            this.termination.countDown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown = true;
        if (this.isTerminated()) {
            this.termination.countDown();
            return Collections.emptyList();
        }
        ArrayList<Runnable> failed = new ArrayList<Runnable>(this.queue.size());
        this.queue.drainTo(failed);
        for (Thread t2 : this.liveThreads) {
            t2.interrupt();
        }
        return failed;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown() && this.queue.isEmpty() && this.runnerPermit.availablePermits() == this.maxWorkers;
    }

    @Override
    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        if (this.isTerminated()) {
            return true;
        }
        return this.termination.await(time, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable r) {
        if (this.shutdown) {
            throw new RejectedExecutionException("Executor is shutting down");
        }
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    this.queue.put(r);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.shutdown && this.queue.remove(r)) {
            throw new RejectedExecutionException("Executor is shutting down");
        }
        if (this.runnerPermit.tryAcquire()) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        PartitionedUnorderedExecutor.this.liveThreads.add(Thread.currentThread());
                        try {
                            ((Runnable)PartitionedUnorderedExecutor.this.queue.remove()).run();
                        }
                        finally {
                            PartitionedUnorderedExecutor.this.liveThreads.remove(Thread.currentThread());
                        }
                    }
                    finally {
                        if (PartitionedUnorderedExecutor.this.queue.isEmpty()) {
                            PartitionedUnorderedExecutor.this.runnerPermit.release();
                            if (!PartitionedUnorderedExecutor.this.queue.isEmpty() && PartitionedUnorderedExecutor.this.runnerPermit.tryAcquire()) {
                                PartitionedUnorderedExecutor.this.executor.submit(this);
                            } else if (PartitionedUnorderedExecutor.this.isTerminated()) {
                                PartitionedUnorderedExecutor.this.termination.countDown();
                            }
                        } else {
                            PartitionedUnorderedExecutor.this.executor.submit(this);
                        }
                    }
                }
            });
        }
    }
}

