/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import org.ehcache.jsr107.CloseUtil;
import org.ehcache.jsr107.EventListenerAdaptors;

class ListenerResources<K, V>
implements Closeable {
    private final CacheEntryListener<? super K, ? super V> listener;
    private final CacheEntryEventFilter<? super K, ? super V> filter;
    private List<EventListenerAdaptors.EventListenerAdaptor<K, V>> ehListeners = null;

    static <K, V> ListenerResources<K, V> createListenerResources(CacheEntryListenerConfiguration<K, V> listenerConfig) {
        CacheEntryEventFilter filter;
        CacheEntryListener<K, V> listener = listenerConfig.getCacheEntryListenerFactory().create();
        try {
            Factory<CacheEntryEventFilter<K, V>> filterFactory = listenerConfig.getCacheEntryEventFilterFactory();
            filter = filterFactory != null ? listenerConfig.getCacheEntryEventFilterFactory().create() : event -> true;
        }
        catch (Throwable t2) {
            throw CloseUtil.closeAllAfter(new CacheException(t2), listener);
        }
        try {
            return new ListenerResources<K, V>(listener, filter);
        }
        catch (Throwable t3) {
            throw CloseUtil.closeAllAfter(new CacheException(t3), filter, listener);
        }
    }

    ListenerResources(CacheEntryListener<? super K, ? super V> listener, CacheEntryEventFilter<? super K, ? super V> filter) {
        this.listener = listener;
        this.filter = filter;
    }

    CacheEntryEventFilter<? super K, ? super V> getFilter() {
        return this.filter;
    }

    CacheEntryListener<? super K, ? super V> getListener() {
        return this.listener;
    }

    synchronized List<EventListenerAdaptors.EventListenerAdaptor<K, V>> getEhcacheListeners(Cache<K, V> source, boolean requestsOld) {
        if (this.ehListeners == null) {
            this.ehListeners = EventListenerAdaptors.ehListenersFor(this.listener, this.filter, source, requestsOld);
        }
        return Collections.unmodifiableList(this.ehListeners);
    }

    @Override
    public void close() {
        try {
            CloseUtil.closeAll(this.listener, this.filter);
        }
        catch (Throwable t2) {
            throw new CacheException(t2);
        }
    }
}

