/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.utilities.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ehcache.shadow.org.terracotta.utilities.exec.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilesSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesSupport.class);
    private static final boolean IS_WINDOWS = System.getProperty("os.name", "").toLowerCase(Locale.ROOT).startsWith("win");
    private static final Pattern SUBST_PAIR = Pattern.compile("(.*): => (.*)");

    FilesSupport() {
    }

    static Set<String> getRetryReasons() {
        LinkedHashSet<String> reasons = new LinkedHashSet<String>();
        for (String reason : FilesSupport.calculateReasons()) {
            if (reason == null) continue;
            reasons.add(reason);
        }
        LOGGER.trace("Retry reason = {}", (Object)reasons);
        return Collections.unmodifiableSet(reasons);
    }

    static List<String> pathType(BasicFileAttributes attributes) {
        ArrayList<String> attrs = new ArrayList<String>();
        if (attributes.isDirectory()) {
            attrs.add("dir");
        }
        if (attributes.isRegularFile()) {
            attrs.add("file");
        }
        if (attributes.isSymbolicLink()) {
            attrs.add("link");
        }
        if (attributes.isOther()) {
            attrs.add("other");
        }
        return attrs;
    }

    static Map<Path, Path> getSubsts() {
        if (!IS_WINDOWS) {
            return Collections.emptyMap();
        }
        try {
            LinkedHashMap<Path, Path> substs = new LinkedHashMap<Path, Path>();
            for (String subst : Shell.execute(Shell.Encoding.CHARSET, "subst")) {
                Path mappedPath;
                Matcher matcher = SUBST_PAIR.matcher(subst);
                if (!matcher.matches()) continue;
                Path drive = Paths.get(matcher.group(1), new String[0]);
                String mappedPathName = matcher.group(2);
                try {
                    mappedPath = Paths.get(mappedPathName, new String[0]);
                }
                catch (InvalidPathException e) {
                    LOGGER.warn("Cannot determine mapping for drive {}: \"{}\" contains character not mapped in charset {}", drive, mappedPathName, Shell.Encoding.CHARSET, e);
                    continue;
                }
                if (!Files.exists(mappedPath, new LinkOption[0])) {
                    LOGGER.warn("Cannot determine mapping for drive {}: \"{}\" does not exist", (Object)drive, (Object)mappedPathName);
                    continue;
                }
                substs.put(drive, mappedPath);
            }
            return Collections.unmodifiableMap(substs);
        }
        catch (Exception e) {
            LOGGER.info("Failed to determine drive substitutions", e);
            return Collections.emptyMap();
        }
    }

    private static Set<String> calculateReasons() {
        try {
            return FilesSupport.calculateReasons(Files.createTempDirectory("top", new FileAttribute[0]));
        }
        catch (IOException e) {
            LOGGER.trace("Unexpected I/O error constructing failure reasons", e);
            return Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    static Set<String> calculateReasons(Path top) throws IOException {
        LinkedHashSet<String> linkedHashSet;
        try {
            Throwable throwable;
            PathHolder holder;
            Path dir = Files.createDirectory(top.resolve("dir"), new FileAttribute[0]);
            Path file1 = Files.createFile(dir.resolve("file1"), new FileAttribute[0]);
            Files.write(file1, Collections.singleton("file1"), StandardCharsets.UTF_8, new OpenOption[0]);
            Path file2 = Files.createFile(dir.resolve("file2"), new FileAttribute[0]);
            Files.write(file1, Collections.singleton("file2"), StandardCharsets.UTF_8, new OpenOption[0]);
            LinkedHashSet<String> reasons = new LinkedHashSet<String>();
            try {
                holder = new PathHolder(file1, false);
                throwable = null;
                try {
                    holder.start();
                    file1 = Files.move(file1, file1.resolveSibling("file1_renamed1"), StandardCopyOption.ATOMIC_MOVE);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (holder != null) {
                        if (throwable != null) {
                            try {
                                holder.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            holder.close();
                        }
                    }
                }
            }
            catch (FileSystemException e) {
                reasons.add(e.getReason());
                LOGGER.trace("Observed for file/file OPEN rename {} '{}'", (Object)e.getClass().getSimpleName(), (Object)e.getReason());
            }
            catch (Exception e) {
                LOGGER.trace("Unexpected IOException renaming {}", (Object)file1, (Object)e);
            }
            try {
                holder = new PathHolder(file1, false);
                throwable = null;
                try {
                    holder.start();
                    dir = Files.move(dir, dir.resolveSibling("dir_renamed1"), StandardCopyOption.ATOMIC_MOVE);
                    file1 = dir.resolve(file1.getFileName());
                    file2 = dir.resolve(file2.getFileName());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (holder != null) {
                        if (throwable != null) {
                            try {
                                holder.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            holder.close();
                        }
                    }
                }
            }
            catch (FileSystemException e) {
                reasons.add(e.getReason());
                LOGGER.trace("Observed for file/dir OPEN rename {} '{}'", (Object)e.getClass().getSimpleName(), (Object)e.getReason());
            }
            catch (Exception e) {
                LOGGER.trace("Unexpected IOException renaming {}", (Object)dir, (Object)e);
            }
            try {
                holder = new PathHolder(file1, true);
                throwable = null;
                try {
                    holder.start();
                    file1 = Files.move(file1, file1.resolveSibling("file1_renamed2"), StandardCopyOption.ATOMIC_MOVE);
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (holder != null) {
                        if (throwable != null) {
                            try {
                                holder.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            holder.close();
                        }
                    }
                }
            }
            catch (FileSystemException e) {
                reasons.add(e.getReason());
                LOGGER.trace("Observed for file/file LOCKED rename {} '{}'", (Object)e.getClass().getSimpleName(), (Object)e.getReason());
            }
            catch (Exception e) {
                LOGGER.trace("Unexpected IOException renaming {}", (Object)file1, (Object)e);
            }
            try {
                holder = new PathHolder(file1, true);
                throwable = null;
                try {
                    holder.start();
                    dir = Files.move(dir, dir.resolveSibling("dir_renamed2"), StandardCopyOption.ATOMIC_MOVE);
                    file1 = dir.resolve(file1.getFileName());
                    file2 = dir.resolve(file2.getFileName());
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (holder != null) {
                        if (throwable != null) {
                            try {
                                holder.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                        } else {
                            holder.close();
                        }
                    }
                }
            }
            catch (FileSystemException e) {
                reasons.add(e.getReason());
                LOGGER.trace("Observed for file/dir LOCKED rename {} '{}'", (Object)e.getClass().getSimpleName(), (Object)e.getReason());
            }
            catch (Exception e) {
                LOGGER.trace("Unexpected IOException renaming {}", (Object)dir, (Object)e);
            }
            try {
                holder = new PathHolder(dir, false);
                throwable = null;
                try {
                    holder.start();
                    file1 = Files.move(file1, file1.resolveSibling("file1_renamed3"), StandardCopyOption.ATOMIC_MOVE);
                    LOGGER.trace("Succeeded dir/file rename");
                }
                catch (Throwable throwable10) {
                    throwable = throwable10;
                    throw throwable10;
                }
                finally {
                    if (holder != null) {
                        if (throwable != null) {
                            try {
                                holder.close();
                            }
                            catch (Throwable throwable11) {
                                throwable.addSuppressed(throwable11);
                            }
                        } else {
                            holder.close();
                        }
                    }
                }
            }
            catch (FileSystemException e) {
                reasons.add(e.getReason());
                LOGGER.trace("Observed for dir/file rename {} '{}'", (Object)e.getClass().getSimpleName(), (Object)e.getReason());
            }
            catch (IOException e) {
                LOGGER.trace("Unexpected IOException renaming {}", (Object)file1, (Object)e);
            }
            linkedHashSet = reasons;
        }
        catch (Throwable throwable) {
            try {
                Files.walkFileTree(top, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        this.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        this.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }

                    private void delete(Path path) {
                        try {
                            Files.delete(path);
                        }
                        catch (IOException e) {
                            LOGGER.trace("Cannot delete {}", (Object)path, (Object)e);
                            path.toFile().deleteOnExit();
                        }
                    }
                });
            }
            catch (IOException f) {
                LOGGER.trace("Cannot delete {}", (Object)top, (Object)f);
            }
            throw throwable;
        }
        try {
            Files.walkFileTree(top, (FileVisitor<? super Path>)new /* invalid duplicate definition of identical inner class */);
        }
        catch (IOException f) {
            LOGGER.trace("Cannot delete {}", (Object)top, (Object)f);
        }
        return linkedHashSet;
    }

    private static class PathHolder
    implements AutoCloseable {
        private static final Logger LOGGER = LoggerFactory.getLogger(PathHolder.class);
        private final Thread thread;
        private final Phaser barrier = new Phaser(2);
        private final AtomicBoolean started = new AtomicBoolean(false);

        private PathHolder(Path path, boolean lock) throws IOException {
            Runnable holder;
            Objects.requireNonNull(path, "path");
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            if (attr.isRegularFile()) {
                holder = lock ? () -> this.lockFile(path) : () -> this.holdFile(path);
            } else if (attr.isDirectory()) {
                holder = () -> this.holdDirectory(path);
            } else {
                throw new AssertionError((Object)("Cannot handle path of type " + FilesSupport.pathType(attr) + " - " + path));
            }
            this.thread = new Thread(holder, "Files$PathHolder - " + path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void holdFile(Path file) {
            LOGGER.trace("Hold on \"{}\" beginning", (Object)file);
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(file.toFile(), "r");){
                randomAccessFile.read();
                this.barrier.arriveAndAwaitAdvance();
                this.barrier.arriveAndAwaitAdvance();
            }
            catch (Exception e) {
                LOGGER.warn("Error attempting to hold \"{}\"", (Object)file, (Object)e);
            }
            finally {
                this.barrier.arriveAndDeregister();
            }
            LOGGER.trace("Hold ended on \"{}\"", (Object)file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lockFile(Path file) {
            LOGGER.trace("Lock on \"{}\" beginning", (Object)file);
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(file.toFile(), "rw");){
                FileChannel channel = randomAccessFile.getChannel();
                try (FileLock ignored = channel.lock();){
                    this.barrier.arriveAndAwaitAdvance();
                    this.barrier.arriveAndAwaitAdvance();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error attempting to lock \"{}\"", (Object)file, (Object)e);
            }
            finally {
                this.barrier.arriveAndDeregister();
            }
            LOGGER.trace("Lock ended on \"{}\"", (Object)file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
        private void holdDirectory(Path dir) {
            LOGGER.trace("Hold on \"{}\" beginning", (Object)dir);
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir);){
                Iterator<Path> iterator = directoryStream.iterator();
                if (iterator.hasNext()) {
                    Path ignored = iterator.next();
                    this.barrier.arriveAndAwaitAdvance();
                    this.barrier.arriveAndAwaitAdvance();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error attempting to hold \"{}\"", (Object)dir, (Object)e);
            }
            finally {
                this.barrier.arriveAndDeregister();
            }
            LOGGER.trace("Hold ended on \"{}\"", (Object)dir);
        }

        public void start() {
            this.thread.setDaemon(true);
            this.thread.start();
            this.started.set(true);
            this.barrier.arriveAndAwaitAdvance();
        }

        @Override
        public void close() {
            if (this.started.compareAndSet(true, false)) {
                this.barrier.arriveAndDeregister();
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

