/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.utilities.logging;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class LoggerBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggerBridge.class);
    private static final Map<Logger, Map<Level, LoggerBridge>> INSTANCES = new ConcurrentHashMap<Logger, Map<Level, LoggerBridge>>();
    private static final Map<Level, MethodHandle> IS_LEVEL_ENABLED = new ConcurrentHashMap<Level, MethodHandle>();
    private static final Map<Level, MethodHandle> LOG = new ConcurrentHashMap<Level, MethodHandle>();
    private static final Map<Level, MethodHandle> LOG_THROWABLE = new ConcurrentHashMap<Level, MethodHandle>();
    private final MethodHandle isLevelEnabled;
    private final MethodHandle log;
    private final MethodHandle logThrowable;

    public static LoggerBridge getInstance(Logger delegate, Level level) {
        try {
            return INSTANCES.computeIfAbsent(delegate, logger -> new ConcurrentHashMap()).computeIfAbsent(level, lvl -> new LoggerBridge(delegate, (Level)((Object)lvl)));
        }
        catch (AssertionError e) {
            LOGGER.error("Failed to obtain " + LoggerBridge.class.getSimpleName() + " instance for Logger \"" + delegate.getName() + "[" + (Object)((Object)level) + "]\"", (Throwable)((Object)e));
            throw e;
        }
    }

    private LoggerBridge(Logger delegate, Level level) {
        Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(level, "level");
        this.isLevelEnabled = IS_LEVEL_ENABLED.computeIfAbsent(level, LoggerBridge::getIsLevelEnabledMethodHandle).bindTo(delegate);
        this.log = LOG.computeIfAbsent(level, LoggerBridge::getLogMethodHandle).bindTo(delegate);
        this.logThrowable = LOG_THROWABLE.computeIfAbsent(level, LoggerBridge::getLogThrowableMethodHandle).bindTo(delegate);
    }

    private static MethodHandle getIsLevelEnabledMethodHandle(Level level) {
        String levelName = level.name();
        try {
            return MethodHandles.publicLookup().findVirtual(Logger.class, "is" + levelName.substring(0, 1).toUpperCase(Locale.ROOT) + levelName.substring(1).toLowerCase(Locale.ROOT) + "Enabled", MethodType.methodType(Boolean.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle getLogMethodHandle(Level level) {
        String methodName = level.name().toLowerCase(Locale.ROOT);
        try {
            return MethodHandles.publicLookup().findVirtual(Logger.class, methodName, MethodType.methodType(Void.TYPE, String.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle getLogThrowableMethodHandle(Level level) {
        String methodName = level.name().toLowerCase(Locale.ROOT);
        try {
            return MethodHandles.publicLookup().findVirtual(Logger.class, methodName, MethodType.methodType(Void.TYPE, String.class, Throwable.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean isLevelEnabled() {
        try {
            return this.isLevelEnabled.invokeExact();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t2) {
            throw new AssertionError((Object)t2);
        }
    }

    public void log(String format, Object ... arguments) {
        try {
            this.log.invokeExact(format, arguments);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }

    public void log(String message, Throwable t2) {
        try {
            this.logThrowable.invokeExact(message, t2);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }
}

