/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.math.BigInteger;
import java.security.AccessController;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParsingUtil {
    private static final Pattern SYSPROP = Pattern.compile("\\$\\{(?<property>[^{}]+)}");
    private static final Pattern PADDED_SYSPROP = Pattern.compile("\\s*" + SYSPROP.pattern() + "\\s*");

    public static String parsePropertyOrString(String s2) {
        Matcher matcher = PADDED_SYSPROP.matcher(s2);
        if (matcher.matches()) {
            String property = matcher.group("property");
            String value = AccessController.doPrivileged(() -> System.getProperty(property));
            if (value == null) {
                throw new IllegalStateException(String.format("Replacement for ${%s} not found!", property));
            }
            return value;
        }
        return s2;
    }

    public static BigInteger parsePropertyOrInteger(String s2) {
        return new BigInteger(ParsingUtil.parsePropertyOrString(s2));
    }

    public static BigInteger parsePropertyOrPositiveInteger(String s2) {
        BigInteger value = ParsingUtil.parsePropertyOrInteger(s2);
        if (value.compareTo(BigInteger.ZERO) > 0) {
            return value;
        }
        throw new IllegalArgumentException("Value " + value + " is not a positive integer");
    }

    public static BigInteger parsePropertyOrNonNegativeInteger(String s2) {
        BigInteger value = ParsingUtil.parsePropertyOrInteger(s2);
        if (value.compareTo(BigInteger.ZERO) >= 0) {
            return value;
        }
        throw new IllegalArgumentException("Value " + value + " is not a non-negative integer");
    }

    public static String parseStringWithProperties(String s2) {
        Matcher matcher = SYSPROP.matcher(s2);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String property = matcher.group("property");
            String value = AccessController.doPrivileged(() -> System.getProperty(property));
            if (value == null) {
                throw new IllegalStateException(String.format("Replacement for ${%s} not found!", property));
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

