/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ehcache.core.util.ClassLoading;
import org.ehcache.xml.Parser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;

public class XmlUtil {
    private static final String EXTERNAL_IDENTIFIER_ATTRIBUTE_NAME = "external-identifier";

    public static Schema newSchema(Source ... schemas) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            schemaFactory.setProperty("http://saxon.sf.net/feature/xsd-version", "1.0");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        schemaFactory.setErrorHandler(new FatalErrorHandler());
        return schemaFactory.newSchema(schemas);
    }

    public static <T> List<T> mergePartialOrderings(Collection<List<T>> orderings) {
        Collection workingCopy = orderings.stream().map(ArrayList::new).collect(Collectors.toCollection(ArrayList::new));
        ArrayList fullOrdering = new ArrayList();
        while (!workingCopy.isEmpty()) {
            boolean progress = false;
            Iterator partials = workingCopy.iterator();
            block1: while (partials.hasNext()) {
                List partial = (List)partials.next();
                if (partial.isEmpty()) {
                    progress = true;
                    partials.remove();
                    continue;
                }
                Supplier<Stream> otherOrderings = () -> workingCopy.stream().filter(o -> o != partial);
                Iterator it = partial.iterator();
                while (it.hasNext()) {
                    Object next = it.next();
                    if (otherOrderings.get().anyMatch(o -> o.indexOf(next) > 0)) continue block1;
                    progress = true;
                    fullOrdering.add(next);
                    otherOrderings.get().forEach(o -> o.remove(next));
                    it.remove();
                }
            }
            if (progress) continue;
            throw new IllegalArgumentException("Incompatible partial orderings: " + orderings);
        }
        return fullOrdering;
    }

    public static <T extends Parser<?>> Iterable<T> namespaceUniqueParsersOfType(Class<T> parserType) {
        ArrayList<Parser> parsers = new ArrayList<Parser>();
        for (Parser parser : ClassLoading.servicesOfType(parserType)) {
            if (!XmlUtil.allowedInParserSet(parsers, parser)) continue;
            parsers.add(parser);
        }
        return Collections.unmodifiableList(parsers);
    }

    private static <T extends Parser<?>> boolean allowedInParserSet(List<T> parsers, T parser) {
        Set<URI> parserTargetNamespaces = parser.getTargetNamespaces();
        Iterator<T> it = parsers.iterator();
        while (it.hasNext()) {
            Parser other = (Parser)it.next();
            Set<URI> otherTargetNamespaces = other.getTargetNamespaces();
            if (parserTargetNamespaces.equals(otherTargetNamespaces)) {
                throw new IllegalArgumentException("Parsers competing for identical namespace set: " + parser + " :: " + other);
            }
            if (parserTargetNamespaces.containsAll(otherTargetNamespaces)) {
                it.remove();
                continue;
            }
            if (otherTargetNamespaces.containsAll(parserTargetNamespaces)) {
                return false;
            }
            HashSet<URI> intersection = new HashSet<URI>(parserTargetNamespaces);
            intersection.retainAll(otherTargetNamespaces);
            if (intersection.isEmpty()) continue;
            throw new IllegalArgumentException("Parsers competing for namespace set: " + intersection + " (neither dominates the other): " + parser + " :: " + other);
        }
        return true;
    }

    public static Document stampExternalConfigurations(Document document) {
        String mainNamespace = document.getDocumentElement().getNamespaceURI();
        NodeList elements = document.getElementsByTagName("*");
        int identifier = 0;
        for (int i = 0; i < elements.getLength(); ++i) {
            Element element = (Element)elements.item(i);
            if (element.getNamespaceURI().equals(mainNamespace)) continue;
            element.setAttributeNS(mainNamespace, EXTERNAL_IDENTIFIER_ATTRIBUTE_NAME, String.valueOf(identifier++));
        }
        return document;
    }

    private static Element cleanExternalConfigurations(Element fragment) {
        String mainNamespace = fragment.getOwnerDocument().getDocumentElement().getNamespaceURI();
        NodeList elements = fragment.getElementsByTagName("*");
        for (int i = 0; i < elements.getLength(); ++i) {
            Element element = (Element)elements.item(i);
            element.removeAttributeNS(mainNamespace, EXTERNAL_IDENTIFIER_ATTRIBUTE_NAME);
        }
        return fragment;
    }

    public static Element findMatchingNodeInDocument(Document document, Element lookup2) {
        String mainNamespace = document.getDocumentElement().getNamespaceURI();
        String identifier = lookup2.getAttributeNS(mainNamespace, EXTERNAL_IDENTIFIER_ATTRIBUTE_NAME);
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException("Cannot lookup unstamped element: " + lookup2);
        }
        NodeList elements = document.getElementsByTagName("*");
        for (int i = 0; i < elements.getLength(); ++i) {
            Element element = (Element)elements.item(i);
            if (!identifier.equals(element.getAttributeNS(mainNamespace, EXTERNAL_IDENTIFIER_ATTRIBUTE_NAME))) continue;
            if (lookup2.getLocalName().equals(element.getLocalName()) && lookup2.getNamespaceURI().equals(element.getNamespaceURI())) {
                return XmlUtil.cleanExternalConfigurations(element);
            }
            throw new IllegalStateException("Lookup of: " + lookup2 + " found mismatched element: " + element);
        }
        throw new IllegalArgumentException("No element found for: " + lookup2);
    }

    public static class FatalErrorHandler
    implements ErrorHandler {
        private static final Collection<Pattern> ABSTRACT_TYPE_FAILURES;

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.fatalError(exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.fatalError(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            if (ABSTRACT_TYPE_FAILURES.stream().anyMatch(pattern -> pattern.matcher(exception.getMessage()).matches())) {
                throw new XmlConfigurationException("Cannot confirm XML sub-type correctness. You might be missing client side libraries.", exception);
            }
            throw exception;
        }

        static {
            List<QName> abstractTypes = Arrays.asList(new QName("http://www.ehcache.org/v3", "service-creation-configuration"), new QName("http://www.ehcache.org/v3", "service-configuration"), new QName("http://www.ehcache.org/v3", "resource"));
            ABSTRACT_TYPE_FAILURES = Arrays.asList(abstractTypes.stream().map(element -> Pattern.quote(String.format("\"%s\":%s", element.getNamespaceURI(), element.getLocalPart()))).collect(Collectors.collectingAndThen(Collectors.joining("|", "^\\Qcvc-complex-type.2.4.a\\E.*'\\{.*(?:", ").*\\}'.*$"), Pattern::compile)), abstractTypes.stream().map(element -> Pattern.quote(element.getLocalPart())).collect(Collectors.collectingAndThen(Collectors.joining("|", "^.*\\QThe content model does not allow element\\E.*(?:", ").*"), Pattern::compile)));
        }
    }
}

