/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver;

import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.saml.metadata.criteria.entity.DetectDuplicateEntityIDsCriterion;
import org.opensaml.saml.metadata.resolver.BatchMetadataResolver;
import org.opensaml.saml.metadata.resolver.ClearableMetadataResolver;
import org.opensaml.saml.metadata.resolver.DetectDuplicateEntityIDs;
import org.opensaml.saml.metadata.resolver.DynamicMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingMetadataResolver
extends AbstractIdentifiableInitializableComponent
implements MetadataResolver,
RefreshableMetadataResolver,
ClearableMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingMetadataResolver.class);
    @Nonnull
    @NonnullElements
    private List<MetadataResolver> resolvers = Collections.emptyList();
    @Nonnull
    private DetectDuplicateEntityIDs detectDuplicateEntityIDs = DetectDuplicateEntityIDs.Off;

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<MetadataResolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(@Nonnull @NonnullElements List<? extends MetadataResolver> newResolvers) throws ResolverException {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        if (newResolvers == null || newResolvers.isEmpty()) {
            this.resolvers = Collections.emptyList();
            return;
        }
        this.resolvers = List.copyOf(newResolvers);
    }

    @Nonnull
    public DetectDuplicateEntityIDs getDetectDuplicateEntityIDs() {
        return this.detectDuplicateEntityIDs;
    }

    public void setDetectDuplicateEntityIDs(@Nullable DetectDuplicateEntityIDs strategy) {
        this.detectDuplicateEntityIDs = strategy != null ? strategy : DetectDuplicateEntityIDs.Off;
    }

    @Override
    public boolean isRequireValidMetadata() {
        this.log.warn("Attempt to access unsupported requireValidMetadata property on ChainingMetadataResolver");
        return false;
    }

    @Override
    public void setRequireValidMetadata(boolean requireValidMetadata) {
        throw new UnsupportedOperationException("Setting requireValidMetadata is not supported on chaining resolver");
    }

    @Override
    public MetadataFilter getMetadataFilter() {
        this.log.warn("Attempt to access unsupported MetadataFilter property on ChainingMetadataResolver");
        return null;
    }

    @Override
    public void setMetadataFilter(MetadataFilter newFilter) {
        throw new UnsupportedOperationException("Metadata filters are not supported on ChainingMetadataResolver");
    }

    @Override
    @Nullable
    public EntityDescriptor resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<EntityDescriptor> iterator;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        Iterable<EntityDescriptor> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    @Nonnull
    public Iterable<EntityDescriptor> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        DetectDuplicateEntityIDs detectDuplicates = this.getDetectDuplicateEntityIDs();
        if (criteria.contains(DetectDuplicateEntityIDsCriterion.class)) {
            detectDuplicates = criteria.get(DetectDuplicateEntityIDsCriterion.class).getValue();
        }
        this.log.trace("Effective DetectDuplicateEntityIDs value is: {}", (Object)detectDuplicates);
        Iterable<EntityDescriptor> result = null;
        Set<String> resultEntityIDs = null;
        for (MetadataResolver resolver2 : this.resolvers) {
            try {
                if (result != null) {
                    this.detectDuplicateEntityIDs(resolver2, criteria, resultEntityIDs, detectDuplicates);
                    continue;
                }
                Iterable<EntityDescriptor> descriptors = resolver2.resolve(criteria);
                if (descriptors == null || !descriptors.iterator().hasNext()) continue;
                if (detectDuplicates == DetectDuplicateEntityIDs.Off) {
                    this.log.trace("Resolved EntityDescriptor(s) from '{}', duplicate detection disabled, returning", (Object)resolver2.getId());
                    return descriptors;
                }
                this.log.trace("Resolved EntityDescriptor(s) from '{}', duplicate detection enabled, continuing", (Object)resolver2.getId());
                result = descriptors;
                resultEntityIDs = this.collectEntityIDs(result);
            }
            catch (ResolverException e) {
                this.log.warn("Error retrieving metadata from resolver of type {}, proceeding to next resolver", (Object)resolver2.getClass().getName(), (Object)e);
            }
        }
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    private void detectDuplicateEntityIDs(@Nonnull MetadataResolver resolver2, @Nonnull CriteriaSet criteria, @Nullable Set<String> resultEntityIDs, @Nonnull DetectDuplicateEntityIDs detectDuplicates) {
        if (resultEntityIDs == null || resultEntityIDs.isEmpty()) {
            return;
        }
        switch (detectDuplicates) {
            case Off: {
                return;
            }
            case Batch: {
                if (BatchMetadataResolver.class.isInstance(resolver2)) break;
                return;
            }
            case Dynamic: {
                if (DynamicMetadataResolver.class.isInstance(resolver2)) break;
                return;
            }
            case All: {
                break;
            }
            default: {
                this.log.warn("Saw unknown DetectDuplicateEntityIDs value, can not process: {}", (Object)detectDuplicates);
                return;
            }
        }
        this.log.trace("Performing duplicate entityID detection on resolver '{} of type {}", (Object)resolver2.getId(), (Object)resolver2.getClass().getName());
        try {
            Iterable<EntityDescriptor> descriptors = resolver2.resolve(criteria);
            if (descriptors != null && descriptors.iterator().hasNext()) {
                Set<String> descriptorsEnitityIDs = this.collectEntityIDs(descriptors);
                Set duplicates = resultEntityIDs.stream().filter(descriptorsEnitityIDs::contains).collect(Collectors.toSet());
                if (!duplicates.isEmpty()) {
                    this.log.warn("MetadataResolver '{}' contained duplicate entityIDs relative to the returned results: {}", (Object)resolver2.getId(), (Object)duplicates);
                }
            }
        }
        catch (ResolverException e) {
            this.log.warn("During duplicate detection, error retrieving metadata from resolver '{}' of type {}", resolver2.getId(), resolver2.getClass().getName(), e);
        }
    }

    private Set<String> collectEntityIDs(@Nonnull Iterable<EntityDescriptor> descriptors) {
        return StreamSupport.stream(descriptors.spliterator(), false).map(EntityDescriptor::getEntityID).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public void clear() throws ResolverException {
        for (MetadataResolver resolver2 : this.resolvers) {
            if (!(resolver2 instanceof ClearableMetadataResolver)) continue;
            ((ClearableMetadataResolver)resolver2).clear();
        }
    }

    @Override
    public void clear(String entityID) throws ResolverException {
        for (MetadataResolver resolver2 : this.resolvers) {
            if (!(resolver2 instanceof ClearableMetadataResolver)) continue;
            ((ClearableMetadataResolver)resolver2).clear(entityID);
        }
    }

    @Override
    public void refresh() throws ResolverException {
        for (MetadataResolver resolver2 : this.resolvers) {
            if (!(resolver2 instanceof RefreshableMetadataResolver)) continue;
            ((RefreshableMetadataResolver)resolver2).refresh();
        }
    }

    @Override
    @Nullable
    public Instant getLastUpdate() {
        Instant ret = null;
        for (MetadataResolver resolver2 : this.resolvers) {
            if (!(resolver2 instanceof RefreshableMetadataResolver)) continue;
            Instant lastUpdate = ((RefreshableMetadataResolver)resolver2).getLastUpdate();
            if (lastUpdate == null) {
                return null;
            }
            if (ret != null && !ret.isBefore(lastUpdate)) continue;
            ret = lastUpdate;
        }
        return ret;
    }

    @Override
    @Nullable
    public Instant getLastRefresh() {
        Instant ret = null;
        for (MetadataResolver resolver2 : this.resolvers) {
            if (!(resolver2 instanceof RefreshableMetadataResolver)) continue;
            Instant lastRefresh = ((RefreshableMetadataResolver)resolver2).getLastRefresh();
            if (lastRefresh == null) {
                return null;
            }
            if (ret != null && !ret.isBefore(lastRefresh)) continue;
            ret = lastRefresh;
        }
        return ret;
    }

    @Override
    public Instant getLastSuccessfulRefresh() {
        Instant ret = null;
        for (MetadataResolver resolver2 : this.resolvers) {
            if (!(resolver2 instanceof RefreshableMetadataResolver)) continue;
            Instant lastSuccessRefresh = ((RefreshableMetadataResolver)resolver2).getLastSuccessfulRefresh();
            if (lastSuccessRefresh == null) {
                return null;
            }
            if (ret != null && !ret.isBefore(lastSuccessRefresh)) continue;
            ret = lastSuccessRefresh;
        }
        return ret;
    }

    @Override
    public Boolean wasLastRefreshSuccess() {
        for (MetadataResolver resolver2 : this.resolvers) {
            RefreshableMetadataResolver refreshable;
            if (!(resolver2 instanceof RefreshableMetadataResolver) || (refreshable = (RefreshableMetadataResolver)resolver2).wasLastRefreshSuccess() == null || refreshable.wasLastRefreshSuccess().booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Throwable getLastFailureCause() {
        for (MetadataResolver resolver2 : this.resolvers) {
            RefreshableMetadataResolver refreshable;
            if (!(resolver2 instanceof RefreshableMetadataResolver) || (refreshable = (RefreshableMetadataResolver)resolver2).getLastFailureCause() == null) continue;
            return refreshable.getLastFailureCause();
        }
        return null;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolvers == null) {
            this.log.warn("ChainingMetadataResolver was not configured with any member MetadataResolvers");
            this.resolvers = Collections.emptyList();
        }
    }

    @Override
    protected void doDestroy() {
        super.doDestroy();
        this.resolvers = Collections.emptyList();
    }
}

