/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Validator;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.SchemaBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.xml.SAMLSchemaBuilder;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SchemaValidationFilter
implements MetadataFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SchemaValidationFilter.class);
    @Nullable
    private SchemaBuilder schemaBuilder;
    @Nonnull
    private SAMLSchemaBuilder samlSchemaBuilder;

    public SchemaValidationFilter(@Nonnull @ParameterName(name="builder") SAMLSchemaBuilder builder) {
        this.samlSchemaBuilder = Constraint.isNotNull(builder, "SAMLSchemaBuilder cannot be null");
    }

    @Override
    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        Validator schemaValidator;
        if (metadata == null) {
            return null;
        }
        try {
            schemaValidator = this.samlSchemaBuilder.getSAMLSchema().newValidator();
        }
        catch (SAXException e) {
            this.log.error("Unable to build metadata validation schema: {}", (Object)e.getMessage());
            throw new FilterException("Unable to build metadata validation schema", e);
        }
        try {
            schemaValidator.validate(new DOMSource(metadata.getDOM()));
        }
        catch (Exception e) {
            this.log.error("Incoming metadata was not schema valid: {}", (Object)e.getMessage());
            throw new FilterException("Incoming metadata was not schema valid", e);
        }
        return metadata;
    }
}

