/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.impl.AbstractBatchMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DOMMetadataResolver
extends AbstractBatchMetadataResolver {
    private final Logger log = LoggerFactory.getLogger(DOMMetadataResolver.class);
    private Element metadataElement;

    public DOMMetadataResolver(Element mdElement) {
        this.metadataElement = mdElement;
    }

    @Override
    protected void doDestroy() {
        this.metadataElement = null;
        super.doDestroy();
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        super.initMetadataResolver();
        try {
            Unmarshaller unmarshaller = this.getUnmarshallerFactory().getUnmarshaller(this.metadataElement);
            XMLObject metadataTemp = unmarshaller.unmarshall(this.metadataElement);
            AbstractBatchMetadataResolver.BatchEntityBackingStore newBackingStore = this.preProcessNewMetadata(metadataTemp);
            this.releaseMetadataDOM(metadataTemp);
            this.setBackingStore(newBackingStore);
        }
        catch (UnmarshallingException e) {
            String errorMsg = "Unable to unmarshall metadata element";
            this.log.error("{} {}: {}", this.getLogPrefix(), "Unable to unmarshall metadata element", e.getMessage());
            throw new ComponentInitializationException("Unable to unmarshall metadata element", e);
        }
        catch (FilterException e) {
            String errorMsg = "Unable to filter metadata";
            this.log.error("{} {}: {}", this.getLogPrefix(), "Unable to filter metadata", e.getMessage());
            throw new ComponentInitializationException("Unable to filter metadata", e);
        }
    }
}

