/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.util.Timer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.http.client.HttpClient;
import org.opensaml.saml.metadata.resolver.impl.AbstractDynamicHTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPEntityIDRequestURLBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionDrivenDynamicHTTPMetadataResolver
extends AbstractDynamicHTTPMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FunctionDrivenDynamicHTTPMetadataResolver.class);
    @Nonnull
    private Function<CriteriaSet, String> requestURLBuilder;

    public FunctionDrivenDynamicHTTPMetadataResolver(@Nonnull HttpClient client) {
        this(null, client);
    }

    public FunctionDrivenDynamicHTTPMetadataResolver(@Nullable Timer backgroundTaskTimer, @Nonnull HttpClient client) {
        super(backgroundTaskTimer, client);
        this.setRequestURLBuilder(new HTTPEntityIDRequestURLBuilder());
    }

    @Nonnull
    public Function<CriteriaSet, String> getRequestURLBuilder() {
        return this.requestURLBuilder;
    }

    public void setRequestURLBuilder(@Nonnull Function<CriteriaSet, String> builder) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.requestURLBuilder = Constraint.isNotNull(builder, "Request URL builder function was null");
    }

    @Override
    @Nullable
    protected String buildRequestURL(@Nonnull CriteriaSet criteria) {
        String url = this.getRequestURLBuilder().apply(criteria);
        this.log.debug("{} URL generated by request builder was: {}", (Object)this.getLogPrefix(), (Object)url);
        return url;
    }
}

