/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.config;

import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.Initializer;
import org.opensaml.security.crypto.ec.ECSupport;
import org.opensaml.security.crypto.ec.NamedCurve;
import org.opensaml.security.crypto.ec.NamedCurveRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalNamedCurveRegistryInitializer
implements Initializer {
    public static final String CONFIG_PROPERTY_REGISTER_BOUNCY_CASTLE_CURVES = "opensaml.config.ec.registerBouncyCastleCurves";
    private Logger log = LoggerFactory.getLogger(GlobalNamedCurveRegistryInitializer.class);

    @Override
    public void init() throws InitializationException {
        boolean registerBCCurves;
        NamedCurveRegistry registry = new NamedCurveRegistry();
        ServiceLoader<NamedCurve> curvesLoader = ServiceLoader.load(NamedCurve.class);
        for (NamedCurve curve : curvesLoader) {
            block6: {
                try {
                    if (!InitializableComponent.class.isInstance(curve)) break block6;
                    ((InitializableComponent)InitializableComponent.class.cast(curve)).initialize();
                }
                catch (ComponentInitializationException e) {
                    this.log.warn("Error initing NamedCurve, name '{}', OID '{}', URI '{}': {}", curve.getName(), curve.getObjectIdentifier(), curve.getURI(), curve.getClass().getName());
                    continue;
                }
            }
            this.log.debug("Registering NamedCurve, name '{}', OID '{}', URI '{}': {}'", curve.getName(), curve.getObjectIdentifier(), curve.getURI(), curve.getClass().getName());
            registry.register(curve);
        }
        Properties props = ConfigurationService.getConfigurationProperties();
        boolean bl = registerBCCurves = props != null ? Boolean.parseBoolean(props.getProperty(CONFIG_PROPERTY_REGISTER_BOUNCY_CASTLE_CURVES)) : false;
        if (registerBCCurves) {
            Set oids = registry.getRegisteredCurves().stream().map(NamedCurve::getObjectIdentifier).collect(Collectors.toSet());
            Set<NamedCurve> curves = ECSupport.getCurvesFromBouncyCastle();
            for (NamedCurve curve : curves) {
                if (!oids.contains(curve.getObjectIdentifier())) {
                    this.log.debug("Registering BC NamedCurve, name '{}', OID '{}', URI '{}': {}'", curve.getName(), curve.getObjectIdentifier(), curve.getURI(), curve.getClass().getName());
                    registry.register(curve);
                    continue;
                }
                this.log.debug("Skipping BC NamedCurve because already registered, name '{}', OID '{}', URI '{}': {}'", curve.getName(), curve.getObjectIdentifier(), curve.getURI(), curve.getClass().getName());
            }
        }
        ConfigurationService.register(NamedCurveRegistry.class, registry);
    }
}

