/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto.ec;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.KeyAgreement;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.crypto.ec.NamedCurve;
import org.opensaml.security.crypto.ec.NamedCurveRegistry;
import org.opensaml.security.crypto.ec.curves.BasicNamedCurve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ECSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ECSupport.class);

    private ECSupport() {
    }

    @Nonnull
    public static byte[] performKeyAgreement(@Nonnull ECPublicKey publicKey, @Nonnull ECPrivateKey privateKey, @Nullable String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Constraint.isNotNull(publicKey, "ECPublicKey was null");
        Constraint.isNotNull(privateKey, "ECPrivateKey was null");
        KeyAgreement keyAgreement = null;
        keyAgreement = provider != null ? KeyAgreement.getInstance("ECDH", provider) : KeyAgreement.getInstance("ECDH");
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(publicKey, true);
        return keyAgreement.generateSecret();
    }

    @Nonnull
    public static KeyPair generateCompatibleKeyPair(@Nonnull ECPublicKey publicKey, @Nullable String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        Constraint.isNotNull(publicKey, "ECPublicKey was null");
        return KeySupport.generateKeyPair("EC", publicKey.getParams(), provider);
    }

    @Nullable
    public static NamedCurveRegistry getGlobalNamedCurveRegistry() {
        return ConfigurationService.get(NamedCurveRegistry.class);
    }

    @Nullable
    public static NamedCurve getNamedCurve(@Nonnull ECPublicKey publicKey) {
        Constraint.isNotNull(publicKey, "ECPublicKey was null");
        NamedCurveRegistry registry = ECSupport.getGlobalNamedCurveRegistry();
        if (registry == null) {
            LOG.warn("No NamedCurveRegistry is configured");
            return null;
        }
        return registry.getByParameterSpec(publicKey.getParams());
    }

    @Nullable
    public static NamedCurve getNamedCurve(@Nonnull String uri) {
        Constraint.isNotNull(uri, "NamedCurve URI was null");
        NamedCurveRegistry registry = ECSupport.getGlobalNamedCurveRegistry();
        if (registry == null) {
            LOG.warn("No NamedCurveRegistry is configured");
            return null;
        }
        return registry.getByURI(uri);
    }

    @Nullable
    public static String getNamedCurveURI(@Nonnull ECPublicKey publicKey) {
        Constraint.isNotNull(publicKey, "ECPublicKey was null");
        NamedCurve namedCurve = ECSupport.getNamedCurve(publicKey);
        if (namedCurve == null) {
            LOG.warn("Could not resolve NamedCurve for ECPublicKey");
            return null;
        }
        return namedCurve.getURI();
    }

    @Nullable
    public static ECParameterSpec getParameterSpecForURI(@Nonnull String uri) {
        Constraint.isNotNull(uri, "NamedCurve URI was null");
        NamedCurve namedCurve = ECSupport.getNamedCurve(uri);
        if (namedCurve == null) {
            LOG.warn("Could not resolve NamedCurve for URI: {}", (Object)uri);
            return null;
        }
        return namedCurve.getParameterSpec();
    }

    @Nonnull
    public static ECPoint decodeECPoint(@Nonnull byte[] data, @Nonnull EllipticCurve curve) throws KeyException {
        Constraint.isNotNull(data, "ECPoint byte array was null");
        Constraint.isNotNull(curve, "EllipticCurve was null");
        if (data.length == 0 || data[0] != 4) {
            throw new KeyException("Only uncompressed point format supported");
        }
        int n = (data.length - 1) / 2;
        if (n != curve.getField().getFieldSize() + 7 >> 3) {
            throw new KeyException("Point does not match field size");
        }
        byte[] xb = Arrays.copyOfRange(data, 1, 1 + n);
        byte[] yb = Arrays.copyOfRange(data, n + 1, n + 1 + n);
        return new ECPoint(new BigInteger(1, xb), new BigInteger(1, yb));
    }

    @Nonnull
    public static byte[] encodeECPointUncompressed(@Nonnull ECPoint point, @Nonnull EllipticCurve curve) {
        Constraint.isNotNull(point, "ECPoint was null");
        Constraint.isNotNull(curve, "EllipticCurve was null");
        int n = curve.getField().getFieldSize() + 7 >> 3;
        byte[] xb = ECSupport.trimZeroes(point.getAffineX().toByteArray());
        byte[] yb = ECSupport.trimZeroes(point.getAffineY().toByteArray());
        if (xb.length > n || yb.length > n) {
            throw new IllegalArgumentException("Point coordinates do not match field size");
        }
        byte[] b = new byte[1 + (n << 1)];
        b[0] = 4;
        System.arraycopy(xb, 0, b, n - xb.length + 1, xb.length);
        System.arraycopy(yb, 0, b, b.length - yb.length, yb.length);
        return b;
    }

    @Nonnull
    private static byte[] trimZeroes(@Nonnull byte[] b) {
        int i;
        Constraint.isNotNull(b, "byte[] data was null");
        for (i = 0; i < b.length - 1 && b[i] == 0; ++i) {
        }
        if (i == 0) {
            return b;
        }
        return Arrays.copyOfRange(b, i, b.length);
    }

    @Nullable
    public static ECParameterSpec convert(@Nullable ECNamedCurveParameterSpec bcSpec) {
        if (bcSpec == null) {
            return null;
        }
        return new ECParameterSpec(EC5Util.convertCurve(bcSpec.getCurve(), bcSpec.getSeed()), EC5Util.convertPoint(bcSpec.getG()), bcSpec.getN(), bcSpec.getH().intValue());
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public static Set<NamedCurve> getCurvesFromBouncyCastle() {
        HashSet<NamedCurve> curves = new HashSet<NamedCurve>();
        HashSet<String> oids = new HashSet<String>();
        Enumeration standardNames = ECNamedCurveTable.getNames();
        while (standardNames.hasMoreElements()) {
            String name = (String)standardNames.nextElement();
            String oid = ECNamedCurveTable.getOID(name).getId();
            if (oids.contains(oid)) continue;
            ECParameterSpec paramSpec = EC5Util.convertToSpec(ECNamedCurveTable.getByName(name));
            curves.add(new BasicNamedCurve(oid, name, paramSpec));
            oids.add(oid);
        }
        Enumeration customNames = CustomNamedCurves.getNames();
        while (customNames.hasMoreElements()) {
            String name = (String)customNames.nextElement();
            String oid = CustomNamedCurves.getOID(name).getId();
            if (oids.contains(oid)) continue;
            ECParameterSpec paramSpec = EC5Util.convertToSpec(CustomNamedCurves.getByName(name));
            curves.add(new BasicNamedCurve(oid, name, paramSpec));
            oids.add(oid);
        }
        return curves;
    }
}

