/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import javax.annotation.Nonnull;
import javax.crypto.SecretKey;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.KeyAgreementSupport;
import org.opensaml.xmlsec.agreement.impl.AbstractKeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.impl.KeySize;
import org.opensaml.xmlsec.derivation.KeyDerivation;
import org.opensaml.xmlsec.derivation.KeyDerivationException;

public abstract class AbstractDerivationKeyAgreementProcessor
extends AbstractKeyAgreementProcessor {
    @Override
    protected SecretKey deriveSecretKey(@Nonnull byte[] secret, @Nonnull String keyAlgorithm, @Nonnull KeyAgreementParameters parameters) throws KeyAgreementException {
        KeyDerivation keyDerivation = parameters.stream().filter(KeyDerivation.class::isInstance).map(KeyDerivation.class::cast).findFirst().orElse(null);
        if (keyDerivation == null) {
            throw new KeyAgreementException("Required KeyDerivation parameter was not supplied");
        }
        Integer keySize = parameters.contains(KeySize.class) ? parameters.get(KeySize.class).getSize() : null;
        KeyAgreementSupport.validateKeyAlgorithmAndSize(keyAlgorithm, keySize);
        try {
            return keyDerivation.derive(secret, keyAlgorithm, keySize);
        }
        catch (KeyDerivationException e) {
            throw new KeyAgreementException("Key derivation failed using supplied KeyDerivation parameter", e);
        }
    }
}

