/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.xmlsec.agreement.CloneableKeyAgreementParameter;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameter;
import org.opensaml.xmlsec.agreement.XMLExpressableKeyAgreementParameter;
import org.opensaml.xmlsec.agreement.impl.KeyAgreementParameterParser;

public class DigestMethod
extends AbstractInitializableComponent
implements XMLExpressableKeyAgreementParameter,
CloneableKeyAgreementParameter {
    @Nullable
    private String algorithm;

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if (this.algorithm == null) {
            throw new ComponentInitializationException("DigestMethod algorithm was null");
        }
    }

    @Nullable
    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(@Nullable String newAlgorithm) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.algorithm = StringSupport.trimOrNull(newAlgorithm);
    }

    @Override
    public DigestMethod clone() {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        try {
            return (DigestMethod)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    @Nonnull
    public XMLObject buildXMLObject() {
        org.opensaml.xmlsec.signature.DigestMethod digestMethod = (org.opensaml.xmlsec.signature.DigestMethod)XMLObjectSupport.buildXMLObject(org.opensaml.xmlsec.signature.DigestMethod.DEFAULT_ELEMENT_NAME);
        digestMethod.setAlgorithm(this.getAlgorithm());
        return digestMethod;
    }

    @Nonnull
    public static DigestMethod fromXMLObject(@Nonnull org.opensaml.xmlsec.signature.DigestMethod xmlObject) throws ComponentInitializationException {
        Constraint.isNotNull(xmlObject, "XMLObject was null");
        DigestMethod parameter = new DigestMethod();
        parameter.setAlgorithm(xmlObject.getAlgorithm());
        parameter.initialize();
        return parameter;
    }

    public static class Parser
    implements KeyAgreementParameterParser {
        @Override
        public boolean handles(@Nonnull XMLObject xmlObject) {
            return org.opensaml.xmlsec.signature.DigestMethod.class.isInstance(xmlObject);
        }

        @Override
        public KeyAgreementParameter parse(@Nonnull XMLObject xmlObject) throws KeyAgreementException {
            if (!this.handles(xmlObject)) {
                throw new KeyAgreementException("This implementation does not handle: " + xmlObject.getClass().getName());
            }
            try {
                return DigestMethod.fromXMLObject((org.opensaml.xmlsec.signature.DigestMethod)org.opensaml.xmlsec.signature.DigestMethod.class.cast(xmlObject));
            }
            catch (ComponentInitializationException e) {
                throw new KeyAgreementException(e);
            }
        }
    }
}

