/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import java.security.SecureRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.xmlsec.agreement.CloneableKeyAgreementParameter;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameter;
import org.opensaml.xmlsec.agreement.XMLExpressableKeyAgreementParameter;
import org.opensaml.xmlsec.agreement.impl.KeyAgreementParameterParser;

public class KANonce
extends AbstractInitializableComponent
implements XMLExpressableKeyAgreementParameter,
CloneableKeyAgreementParameter {
    public static final Integer DEFAULT_GENERATED_LENGTH = 8;
    @Nullable
    private String value;
    @NonnullAfterInit
    private Integer generatedLength;
    @NonnullAfterInit
    private SecureRandom secureRandom;

    @Nullable
    public String getValue() {
        if (this.value == null && this.isInitialized()) {
            this.value = this.generateValue();
        }
        return this.value;
    }

    public void setValue(@Nullable String newValue) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.value = StringSupport.trimOrNull(newValue);
    }

    @NonnullAfterInit
    public Integer getGeneratedLength() {
        return this.generatedLength;
    }

    public void setGeneratedLength(@Nullable Integer length) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.generatedLength = length;
    }

    @NonnullAfterInit
    public SecureRandom getRandom() {
        return this.secureRandom;
    }

    public void setRandom(@Nullable SecureRandom sr) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.secureRandom = sr;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if (this.value != null) {
            try {
                Base64Support.decode(this.value);
            }
            catch (DecodingException e) {
                throw new ComponentInitializationException("Nonce value was not valid Base64", e);
            }
        }
        if (this.generatedLength == null) {
            this.generatedLength = DEFAULT_GENERATED_LENGTH;
        }
        if (this.secureRandom == null) {
            this.secureRandom = new SecureRandom();
        }
    }

    protected String generateValue() {
        try {
            byte[] valueBytes = new byte[this.generatedLength.intValue()];
            this.secureRandom.nextBytes(valueBytes);
            return Base64Support.encode(valueBytes, false);
        }
        catch (EncodingException e) {
            throw new XMLRuntimeException("Error Base64-encoding generated nonce value salt", e);
        }
    }

    @Override
    public KANonce clone() {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        try {
            return (KANonce)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    @Nonnull
    public XMLObject buildXMLObject() {
        org.opensaml.xmlsec.encryption.KANonce nonce = (org.opensaml.xmlsec.encryption.KANonce)XMLObjectSupport.buildXMLObject(org.opensaml.xmlsec.encryption.KANonce.DEFAULT_ELEMENT_NAME);
        nonce.setValue(this.getValue());
        return nonce;
    }

    @Nonnull
    public static KANonce fromXMLObject(@Nonnull org.opensaml.xmlsec.encryption.KANonce xmlObject) throws ComponentInitializationException {
        Constraint.isNotNull(xmlObject, "XMLObject was null");
        if (StringSupport.trimOrNull(xmlObject.getValue()) == null) {
            throw new ComponentInitializationException("XML KANonce had a null or empty value");
        }
        KANonce parameter = new KANonce();
        parameter.setValue(xmlObject.getValue());
        parameter.initialize();
        return parameter;
    }

    public static class Parser
    implements KeyAgreementParameterParser {
        @Override
        public boolean handles(@Nonnull XMLObject xmlObject) {
            return org.opensaml.xmlsec.encryption.KANonce.class.isInstance(xmlObject);
        }

        @Override
        public KeyAgreementParameter parse(@Nonnull XMLObject xmlObject) throws KeyAgreementException {
            if (!this.handles(xmlObject)) {
                throw new KeyAgreementException("This implementation does not handle: " + xmlObject.getClass().getName());
            }
            try {
                return KANonce.fromXMLObject((org.opensaml.xmlsec.encryption.KANonce)org.opensaml.xmlsec.encryption.KANonce.class.cast(xmlObject));
            }
            catch (ComponentInitializationException e) {
                throw new KeyAgreementException(e);
            }
        }
    }
}

