/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.KeyAgreementSupport;
import org.opensaml.xmlsec.agreement.impl.KeyAgreementParameterParser;
import org.opensaml.xmlsec.agreement.impl.KeySize;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyAgreementParametersParser {
    private Logger log = LoggerFactory.getLogger(KeyAgreementParametersParser.class);

    @Nonnull
    public KeyAgreementParameters parse(@Nonnull AgreementMethod agreementMethod) throws KeyAgreementException {
        Constraint.isNotNull(agreementMethod, "AgreementMethod was null");
        KeyAgreementParameters parameters = new KeyAgreementParameters();
        List<KeyAgreementParameterParser> parsers = this.getParsers();
        ArrayList<XMLObject> xmlChildren = Lists.newArrayList(agreementMethod.getUnknownXMLObjects());
        if (agreementMethod.getKANonce() != null) {
            xmlChildren.add(agreementMethod.getKANonce());
        }
        for (XMLObject xmlChild : xmlChildren) {
            boolean handled = false;
            for (KeyAgreementParameterParser parser : parsers) {
                if (!parser.handles(xmlChild)) continue;
                this.log.debug("AgreementMethod child '{}' was indicated to be handled by: {}", (Object)xmlChild.getElementQName(), (Object)parser.getClass().getName());
                parameters.add(parser.parse(xmlChild));
                handled = true;
            }
            if (handled) continue;
            throw new KeyAgreementException("AgreementMethod child is not a supported parameter type: " + xmlChild.getElementQName());
        }
        Integer keySize = KeyAgreementSupport.getExplicitKeySize(agreementMethod);
        if (keySize != null) {
            parameters.add(new KeySize(keySize));
        }
        parameters.initializeAll();
        return parameters;
    }

    @Nonnull
    protected List<KeyAgreementParameterParser> getParsers() {
        ServiceLoader<KeyAgreementParameterParser> loader = ServiceLoader.load(KeyAgreementParameterParser.class);
        return Lists.newArrayList(loader);
    }
}

