/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.derivation.impl;

import com.google.common.base.Charsets;
import com.google.common.primitives.Bytes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.commons.codec.binary.Hex;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.derivation.KeyDerivationException;
import org.opensaml.xmlsec.derivation.KeyDerivationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHLegacyKDF {
    private final Logger log = LoggerFactory.getLogger(DHLegacyKDF.class);
    @Nullable
    private String digestMethod;
    @Nullable
    private String nonce;

    @Nullable
    public String getDigestMethod() {
        return this.digestMethod;
    }

    public void setDigestMethod(@Nullable String newDigestMethod) {
        this.digestMethod = StringSupport.trimOrNull(newDigestMethod);
    }

    @Nullable
    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(@Nullable String newNonce) {
        this.nonce = StringSupport.trimOrNull(newNonce);
    }

    public SecretKey derive(@Nonnull byte[] secret, @Nonnull String keyAlgorithm, @Nullable Integer keyLength) throws KeyDerivationException {
        Constraint.isNotNull(secret, "Secret byte[] was null");
        Constraint.isNotNull(keyAlgorithm, "Key algorithm was null");
        String jcaKeyAlgorithm = KeyDerivationSupport.getJCAKeyAlgorithm(keyAlgorithm);
        Integer jcaKeyLength = KeyDerivationSupport.getEffectiveKeyLength(keyAlgorithm, keyLength);
        byte[] keyBytes = this.deriveBytes(secret, keyAlgorithm, jcaKeyLength);
        return new SecretKeySpec(keyBytes, jcaKeyAlgorithm);
    }

    protected byte[] deriveBytes(@Nonnull byte[] secret, @Nonnull String encryptionAlgorithm, @Nonnull Integer keyLength) throws KeyDerivationException {
        byte[] derived = new byte[]{};
        String jcaDigest = AlgorithmSupport.getAlgorithmID(this.digestMethod);
        if (jcaDigest == null) {
            this.log.warn("Could not resolve JCA algorithm ID from URI: {}", (Object)jcaDigest);
            throw new KeyDerivationException("Could not resolve JCA digest from URI: " + this.digestMethod);
        }
        try {
            byte[] nonceBytes = this.nonce != null ? Base64Support.decode(this.nonce) : new byte[]{};
            int counter = 0;
            while (derived.length * 8 < keyLength) {
                derived = Bytes.concat(derived, this.digest(++counter, jcaDigest, secret, encryptionAlgorithm, keyLength, nonceBytes));
            }
        }
        catch (DecodingException e) {
            this.log.error("Fatal error Base64-decoding supplied nonce value: {}", (Object)this.nonce, (Object)e);
            throw new KeyDerivationException("Fatal error decoding nonce", e);
        }
        return Arrays.copyOfRange(derived, 0, keyLength / 8);
    }

    protected byte[] digest(int counter, @Nonnull String digestAlgorithm, @Nonnull byte[] secret, @Nonnull String encryptionAlgorithm, @Nonnull Integer keyLength, @Nonnull byte[] nonceBytes) throws KeyDerivationException {
        byte[] digestInput = Bytes.concat(secret, String.format("%02d", counter).getBytes(Charsets.UTF_8), encryptionAlgorithm.getBytes(Charsets.UTF_8), nonceBytes, keyLength.toString().getBytes(Charsets.UTF_8));
        this.log.trace("Digest input for counter={} in hex was: {}", (Object)counter, (Object)Hex.encodeHexString(digestInput, false));
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            byte[] output = md.digest(digestInput);
            this.log.trace("Digest output for counter={} in hex was: {}", (Object)counter, (Object)Hex.encodeHexString(output, false));
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyDerivationException("Fatal error computing digest for key derivation", e);
        }
    }
}

