/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl.provider;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.agreement.KeyAgreementCredential;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessorRegistry;
import org.opensaml.xmlsec.agreement.KeyAgreementSupport;
import org.opensaml.xmlsec.agreement.impl.KeyAgreementParametersParser;
import org.opensaml.xmlsec.agreement.impl.PrivateCredential;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.EncryptedType;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolutionMode;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCriterion;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoCredentialContext;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoResolutionContext;
import org.opensaml.xmlsec.keyinfo.impl.provider.AbstractKeyInfoProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgreementMethodKeyInfoProvider
extends AbstractKeyInfoProvider {
    private final Logger log = LoggerFactory.getLogger(AgreementMethodKeyInfoProvider.class);
    private final KeyAgreementParametersParser parametersParser = new KeyAgreementParametersParser();

    @Override
    public boolean handles(@Nonnull XMLObject keyInfoChild) {
        if (!AgreementMethod.class.isInstance(keyInfoChild)) {
            this.log.debug("XMLObject is not an AgreementMethod");
            return false;
        }
        AgreementMethod agreementMethod = (AgreementMethod)AgreementMethod.class.cast(keyInfoChild);
        KeyAgreementProcessorRegistry registry = KeyAgreementSupport.getGlobalProcessorRegistry();
        if (registry == null) {
            this.log.debug("Global KeyAgreementProcessorRegistry is not configured");
            return false;
        }
        if (!registry.getRegisteredAlgorithms().contains(agreementMethod.getAlgorithm())) {
            this.log.debug("No KeyAgreementProcessor registered for algorithm: {}", (Object)agreementMethod.getAlgorithm());
            return false;
        }
        if (agreementMethod.getParent() == null || agreementMethod.getParent().getParent() == null || !EncryptedType.class.isInstance(agreementMethod.getParent().getParent())) {
            this.log.debug("AgreementMethod is not the grandchild of an EncryptedType element");
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Collection<Credential> process(@Nonnull KeyInfoCredentialResolver resolver2, @Nonnull XMLObject keyInfoChild, @Nullable CriteriaSet criteriaSet, @Nonnull KeyInfoResolutionContext kiContext) throws SecurityException {
        if (!this.handles(keyInfoChild)) {
            return null;
        }
        AgreementMethod agreementMethod = (AgreementMethod)AgreementMethod.class.cast(keyInfoChild);
        KeyAgreementProcessor processor = KeyAgreementSupport.getGlobalProcessorRegistry().getProcessor(agreementMethod.getAlgorithm());
        this.log.debug("Attempting to process key agreemenent for algorithm: {}", (Object)processor.getAlgorithm());
        KeyAgreementCredential cred = null;
        try {
            Credential originatorCredential = this.resolveOriginatorCredential(agreementMethod, resolver2);
            Credential recipientCredential = this.resolveRecipientCredential(agreementMethod, resolver2);
            KeyAgreementParameters parameters = this.parametersParser.parse(agreementMethod);
            parameters.add(new PrivateCredential(recipientCredential));
            String keyAlgorithm = this.resolveKeyAlgorithm(agreementMethod);
            cred = processor.execute(originatorCredential, keyAlgorithm, parameters);
        }
        catch (KeyAgreementException e) {
            this.log.error("Error processing AgreementMethod with algorithm: {}", (Object)processor.getAlgorithm(), (Object)e);
            throw new SecurityException("Error processing AgreementMethod", e);
        }
        cred.getKeyNames().addAll(kiContext.getKeyNames());
        KeyInfoCredentialContext credContext = this.buildCredentialContext(kiContext);
        if (credContext != null) {
            cred.getCredentialContextSet().add(credContext);
        }
        this.log.debug("Credential successfully produced by AgreementMethod with algorithm: {}", (Object)cred.getAlgorithm());
        LazySet<Credential> credentialSet = new LazySet<Credential>();
        credentialSet.add(cred);
        return credentialSet;
    }

    @Nonnull
    private String resolveKeyAlgorithm(@Nonnull AgreementMethod agreementMethod) throws SecurityException {
        EncryptedType encrytpedType = (EncryptedType)EncryptedType.class.cast(agreementMethod.getParent().getParent());
        if (encrytpedType.getEncryptionMethod() == null || encrytpedType.getEncryptionMethod().getAlgorithm() == null) {
            throw new SecurityException("EncryptedType contains no EncryptionMethod algorithm");
        }
        return encrytpedType.getEncryptionMethod().getAlgorithm();
    }

    @Nonnull
    private Credential resolveOriginatorCredential(@Nonnull AgreementMethod agreementMethod, @Nonnull KeyInfoCredentialResolver resolver2) throws SecurityException {
        if (agreementMethod.getOriginatorKeyInfo() == null) {
            throw new SecurityException("AgreementMethod OriginatorKeyInfo was null");
        }
        CriteriaSet criteria = new CriteriaSet(new KeyInfoCriterion(agreementMethod.getOriginatorKeyInfo()), new KeyInfoCredentialResolutionMode(KeyInfoCredentialResolutionMode.Mode.PUBLIC));
        try {
            Credential cred = (Credential)resolver2.resolveSingle(criteria);
            if (cred == null) {
                throw new SecurityException("Failed to resolve Credential from OriginatorKeyInfo ");
            }
            return cred;
        }
        catch (ResolverException e) {
            throw new SecurityException("Error resolving Credential from OriginatorKeyInfo", e);
        }
    }

    @Nonnull
    private Credential resolveRecipientCredential(@Nonnull AgreementMethod agreementMethod, @Nonnull KeyInfoCredentialResolver resolver2) throws SecurityException {
        if (agreementMethod.getRecipientKeyInfo() == null) {
            throw new SecurityException("AgreementMethod RecipientKeyInfo was null");
        }
        CriteriaSet criteria = new CriteriaSet(new KeyInfoCriterion(agreementMethod.getRecipientKeyInfo()));
        try {
            Credential cred = (Credential)resolver2.resolveSingle(criteria);
            if (cred == null) {
                throw new SecurityException("Failed to resolve Credential from RecipientKeyInfo ");
            }
            if (cred.getPrivateKey() == null) {
                throw new SecurityException("Credential resolved from RecipientKeyInfo did not contain PrivateKey");
            }
            return cred;
        }
        catch (ResolverException e) {
            throw new SecurityException("Error resolving Credential from RecipientKeyInfo", e);
        }
    }
}

