/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.plugin;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.nio.file.Path;
import network.oxalis.ng.api.plugin.PluginFactory;
import network.oxalis.ng.api.settings.Settings;
import network.oxalis.ng.commons.filesystem.ClassLoaderUtils;
import network.oxalis.ng.commons.filesystem.FileSystemConf;
import network.oxalis.ng.commons.guice.OxalisModule;
import network.oxalis.ng.commons.plugin.PluginFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginModule
extends OxalisModule {
    private static final Logger log = LoggerFactory.getLogger(PluginModule.class);

    @Override
    protected void configure() {
        this.bind(PluginFactory.class).to(PluginFactoryImpl.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    @Named(value="plugin")
    public ClassLoader providesClassLoader(@Named(value="home") Path homeDirectory, Settings<FileSystemConf> settings) {
        Path pluginPath = settings.getPath(FileSystemConf.PLUGIN, homeDirectory);
        log.info("Loading plugins from '{}'.", (Object)pluginPath);
        return ClassLoaderUtils.initiate(pluginPath);
    }
}

