/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.function.Supplier;
import javax.cache.expiry.ExpiryPolicy;
import org.ehcache.core.config.ExpiryUtils;
import org.ehcache.jsr107.Eh107Expiry;

class ExpiryPolicyToEhcacheExpiry<K, V>
extends Eh107Expiry<K, V>
implements Closeable {
    private final ExpiryPolicy expiryPolicy;

    ExpiryPolicyToEhcacheExpiry(ExpiryPolicy expiryPolicy) {
        this.expiryPolicy = expiryPolicy;
    }

    @Override
    public Duration getExpiryForCreation(K key, V value) {
        try {
            javax.cache.expiry.Duration duration = this.expiryPolicy.getExpiryForCreation();
            return this.convertDuration(duration);
        }
        catch (Throwable t2) {
            return Duration.ZERO;
        }
    }

    @Override
    protected Duration getExpiryForAccessInternal(K key, Supplier<? extends V> value) {
        try {
            javax.cache.expiry.Duration duration = this.expiryPolicy.getExpiryForAccess();
            if (duration == null) {
                return null;
            }
            return this.convertDuration(duration);
        }
        catch (Throwable t2) {
            return Duration.ZERO;
        }
    }

    @Override
    public Duration getExpiryForUpdate(K key, Supplier<? extends V> oldValue, V newValue) {
        try {
            javax.cache.expiry.Duration duration = this.expiryPolicy.getExpiryForUpdate();
            if (duration == null) {
                return null;
            }
            return this.convertDuration(duration);
        }
        catch (Throwable t2) {
            return Duration.ZERO;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.expiryPolicy instanceof Closeable) {
            ((Closeable)((Object)this.expiryPolicy)).close();
        }
    }

    private Duration convertDuration(javax.cache.expiry.Duration duration) {
        if (duration.isEternal()) {
            return org.ehcache.expiry.ExpiryPolicy.INFINITE;
        }
        return Duration.of(duration.getDurationAmount(), ExpiryUtils.jucTimeUnitToTemporalUnit(duration.getTimeUnit()));
    }
}

