/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.offheapstore.storage;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import org.ehcache.shadow.org.terracotta.offheapstore.paging.OffHeapStorageArea;
import org.ehcache.shadow.org.terracotta.offheapstore.paging.PageSource;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.PointerSize;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.PortabilityBasedHalfStorageEngine;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.StorageEngine;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.portability.Portability;
import org.ehcache.shadow.org.terracotta.offheapstore.util.DebuggingUtils;
import org.ehcache.shadow.org.terracotta.offheapstore.util.Factory;

public class OffHeapBufferHalfStorageEngine<T>
extends PortabilityBasedHalfStorageEngine<T>
implements OffHeapStorageArea.Owner {
    private static final int KEY_HASH_OFFSET = 0;
    private static final int LENGTH_OFFSET = 4;
    private static final int DATA_OFFSET = 8;
    private static final int HEADER_LENGTH = 8;
    private volatile StorageEngine.Owner owner;
    private volatile long mask;
    private final OffHeapStorageArea storageArea;

    public static <T> Factory<OffHeapBufferHalfStorageEngine<T>> createFactory(PageSource source, int pageSize, Portability<? super T> portability) {
        return OffHeapBufferHalfStorageEngine.createFactory(source, pageSize, portability, false, false);
    }

    public static <T> Factory<OffHeapBufferHalfStorageEngine<T>> createFactory(PageSource source, int pageSize, Portability<? super T> portability, boolean thief, boolean victim) {
        return OffHeapBufferHalfStorageEngine.createFactory(source, pageSize, pageSize, portability, thief, victim);
    }

    public static <T> Factory<OffHeapBufferHalfStorageEngine<T>> createFactory(PageSource source, int initialPageSize, int maximalPageSize, Portability<? super T> portability, boolean thief, boolean victim) {
        return () -> new OffHeapBufferHalfStorageEngine(source, initialPageSize, maximalPageSize, portability, thief, victim);
    }

    public OffHeapBufferHalfStorageEngine(PageSource source, int pageSize, Portability<? super T> portability) {
        this(source, pageSize, portability, false, false);
    }

    public OffHeapBufferHalfStorageEngine(PageSource source, int pageSize, Portability<? super T> portability, boolean thief, boolean victim) {
        this(source, pageSize, pageSize, portability, thief, victim);
    }

    public OffHeapBufferHalfStorageEngine(PageSource source, int initialPageSize, int maximalPageSize, Portability<? super T> portability, boolean thief, boolean victim) {
        super(portability);
        this.storageArea = new OffHeapStorageArea(PointerSize.INT, (OffHeapStorageArea.Owner)this, source, initialPageSize, maximalPageSize, thief, victim);
    }

    @Override
    public void clear() {
        this.storageArea.clear();
    }

    @Override
    public void free(int address) {
        this.storageArea.free(address);
    }

    @Override
    protected ByteBuffer readBuffer(int address) {
        int length = this.storageArea.readInt(address + 4);
        return this.storageArea.readBuffer(address + 8, length);
    }

    @Override
    protected Integer writeBuffer(ByteBuffer buffer, int hash) {
        int length = buffer.remaining();
        int address = (int)this.storageArea.allocate(length + 8);
        if (address >= 0) {
            this.storageArea.writeInt(address + 0, hash);
            this.storageArea.writeInt(address + 4, length);
            this.storageArea.writeBuffer(address + 8, buffer);
            return address;
        }
        return null;
    }

    @Override
    public long getAllocatedMemory() {
        return this.storageArea.getAllocatedMemory();
    }

    @Override
    public long getOccupiedMemory() {
        return this.storageArea.getOccupiedMemory();
    }

    @Override
    public long getVitalMemory() {
        return this.getAllocatedMemory();
    }

    @Override
    public long getDataSize() {
        return this.getOccupiedMemory();
    }

    public String toString() {
        return "OffHeapBufferStorageEngine allocated=" + DebuggingUtils.toBase2SuffixedString(this.getAllocatedMemory()) + "B occupied=" + DebuggingUtils.toBase2SuffixedString(this.getOccupiedMemory()) + "B\nAllocator: " + this.storageArea;
    }

    @Override
    public void bind(StorageEngine.Owner o, long m4) {
        if (this.owner != null) {
            throw new AssertionError();
        }
        this.owner = o;
        this.mask = m4;
    }

    @Override
    public void destroy() {
        this.storageArea.destroy();
    }

    @Override
    public boolean shrink() {
        return this.storageArea.shrink();
    }

    @Override
    public Collection<Long> evictAtAddress(long address, boolean shrink) {
        int hash = this.storageArea.readInt(address + 0L);
        int slot = this.owner.getSlotForHashAndEncoding(hash, address, this.mask);
        if (this.owner.evict(slot, shrink)) {
            return Collections.singleton(address);
        }
        return Collections.emptyList();
    }

    @Override
    public Lock writeLock() {
        return this.owner.writeLock();
    }

    @Override
    public boolean isThief() {
        return this.owner.isThiefForTableAllocations();
    }

    @Override
    public boolean moved(long from, long to) {
        int hash = this.storageArea.readInt(to + 0L);
        return this.owner.updateEncoding(hash, from, to, this.mask);
    }

    @Override
    public int sizeOf(long address) {
        int length = this.storageArea.readInt(address + 4L);
        return 8 + length;
    }
}

