/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.statistics.archive;

import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.ehcache.shadow.org.terracotta.statistics.Sample;
import org.ehcache.shadow.org.terracotta.statistics.ValueStatistic;

public class StatisticSampler<T extends Serializable> {
    private final boolean exclusiveExecutor;
    private final ScheduledExecutorService executor;
    private final SamplingTask<T> task;
    private ScheduledFuture<?> currentExecution;
    private long period;

    public StatisticSampler(long time, TimeUnit unit, ValueStatistic<T> statistic, Consumer<Sample<T>> sink, LongSupplier timeSupplier) {
        this(null, time, unit, statistic, sink, timeSupplier);
    }

    public StatisticSampler(ScheduledExecutorService executor, long time, TimeUnit unit, ValueStatistic<T> statistic, Consumer<Sample<T>> sink, LongSupplier timeSupplier) {
        if (executor == null) {
            this.exclusiveExecutor = true;
            this.executor = Executors.newSingleThreadScheduledExecutor(new SamplerThreadFactory());
        } else {
            this.exclusiveExecutor = false;
            this.executor = executor;
        }
        this.period = unit.toNanos(time);
        this.task = new SamplingTask<T>(statistic, sink, timeSupplier);
    }

    public synchronized void setPeriod(long time, TimeUnit unit) {
        this.period = unit.toNanos(time);
        if (this.currentExecution != null && !this.currentExecution.isDone()) {
            this.stop();
            this.start();
        }
    }

    public synchronized void start() {
        if (this.currentExecution != null && !this.currentExecution.isDone()) {
            throw new IllegalStateException("Sampler is already running");
        }
        this.currentExecution = this.executor.scheduleAtFixedRate(this.task, this.period, this.period, TimeUnit.NANOSECONDS);
    }

    public synchronized void stop() {
        if (this.currentExecution == null || this.currentExecution.isDone()) {
            throw new IllegalStateException("Sampler is not running");
        }
        this.currentExecution.cancel(false);
    }

    public synchronized void shutdown() throws InterruptedException {
        if (this.exclusiveExecutor) {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Exclusive ScheduledExecutorService failed to terminate promptly");
            }
        } else {
            throw new IllegalStateException("ScheduledExecutorService was supplied externally - it must be shutdown directly");
        }
    }

    static class SamplerThreadFactory
    implements ThreadFactory {
        SamplerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t2 = new Thread(r, "Statistic Sampler");
            t2.setDaemon(true);
            return t2;
        }
    }

    static class SamplingTask<T extends Serializable>
    implements Runnable {
        private final ValueStatistic<T> statistic;
        private final Consumer<Sample<T>> sink;
        private final LongSupplier timeSupplier;

        SamplingTask(ValueStatistic<T> statistic, Consumer<Sample<T>> sink, LongSupplier timeSupplier) {
            this.statistic = statistic;
            this.sink = sink;
            this.timeSupplier = timeSupplier;
        }

        @Override
        public void run() {
            this.sink.accept(new Sample<T>(this.timeSupplier.getAsLong(), this.statistic.value()));
        }
    }
}

