/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.decoding.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Resolver;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.MessageException;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.EndpointResolver;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.binding.artifact.SAMLSourceLocationArtifact;
import org.opensaml.saml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml.common.binding.impl.DefaultEndpointResolver;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.soap.SAMLSOAPClientContextBuilder;
import org.opensaml.saml.config.SAMLConfigurationSupport;
import org.opensaml.saml.criterion.ArtifactCriterion;
import org.opensaml.saml.criterion.EndpointCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.binding.artifact.SAML2Artifact;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactBuilderFactory;
import org.opensaml.saml.saml2.core.Artifact;
import org.opensaml.saml.saml2.core.ArtifactResolve;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.SecurityException;
import org.opensaml.soap.client.SOAPClient;
import org.opensaml.soap.common.SOAPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPArtifactDecoder
extends BaseHttpServletRequestXMLMessageDecoder
implements SAMLMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPArtifactDecoder.class);
    @Nullable
    private BindingDescriptor bindingDescriptor;
    @NonnullAfterInit
    private SAML2ArtifactBuilderFactory artifactBuilderFactory;
    @NonnullAfterInit
    private EndpointResolver<ArtifactResolutionService> artifactEndpointResolver;
    @NonnullAfterInit
    private RoleDescriptorResolver roleDescriptorResolver;
    @NonnullAfterInit
    private QName peerEntityRole;
    @NonnullAfterInit
    private Resolver<String, CriteriaSet> selfEntityIDResolver;
    private SOAPClient soapClient;
    private String soapPipelineName;
    private String soapClientSecurityConfigurationProfileId;
    private IdentifierGenerationStrategy idStrategy;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.selfEntityIDResolver == null) {
            throw new ComponentInitializationException("Self entityID resolver cannot be null");
        }
        if (this.roleDescriptorResolver == null) {
            throw new ComponentInitializationException("RoleDescriptorResolver cannot be null");
        }
        if (this.peerEntityRole == null) {
            throw new ComponentInitializationException("Peer entity role cannot be null");
        }
        if (this.soapClient == null) {
            throw new ComponentInitializationException("SOAPClient cannot be null");
        }
        if (this.idStrategy == null) {
            this.idStrategy = new SecureRandomIdentifierGenerationStrategy();
        }
        if (this.artifactBuilderFactory == null) {
            this.artifactBuilderFactory = SAMLConfigurationSupport.getSAML2ArtifactBuilderFactory();
            if (this.artifactBuilderFactory == null) {
                throw new ComponentInitializationException("Could not obtain a required instance of SAML2ArtifactBuilderFactory");
            }
        }
        if (this.artifactEndpointResolver == null) {
            this.artifactEndpointResolver = new DefaultEndpointResolver<ArtifactResolutionService>();
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.bindingDescriptor = null;
        this.artifactBuilderFactory = null;
        this.artifactEndpointResolver = null;
        this.roleDescriptorResolver = null;
        this.peerEntityRole = null;
        this.soapClient = null;
        this.idStrategy = null;
    }

    @NonnullAfterInit
    public IdentifierGenerationStrategy getIdentifierGenerationStrategy() {
        return this.idStrategy;
    }

    public void setIdentifierGenerationStrategy(@Nullable IdentifierGenerationStrategy strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)((Object)this));
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)((Object)this));
        this.idStrategy = strategy;
    }

    @NonnullAfterInit
    public Resolver<String, CriteriaSet> getSelfEntityIDResolver() {
        return this.selfEntityIDResolver;
    }

    public void setSelfEntityIDResolver(@Nonnull Resolver<String, CriteriaSet> resolver2) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)((Object)this));
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)((Object)this));
        this.selfEntityIDResolver = resolver2;
    }

    @NonnullAfterInit
    public QName getPeerEntityRole() {
        return this.peerEntityRole;
    }

    public void setPeerEntityRole(@Nonnull QName role) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)((Object)this));
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)((Object)this));
        this.peerEntityRole = role;
    }

    @NonnullAfterInit
    public EndpointResolver<ArtifactResolutionService> getArtifactEndpointResolver() {
        return this.artifactEndpointResolver;
    }

    public void setArtifactEndpointResolver(@Nullable EndpointResolver<ArtifactResolutionService> resolver2) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)((Object)this));
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)((Object)this));
        this.artifactEndpointResolver = resolver2;
    }

    @NonnullAfterInit
    public RoleDescriptorResolver getRoleDescriptorResolver() {
        return this.roleDescriptorResolver;
    }

    public void setRoleDescriptorResolver(@Nullable RoleDescriptorResolver resolver2) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)((Object)this));
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)((Object)this));
        this.roleDescriptorResolver = resolver2;
    }

    @NonnullAfterInit
    public SAML2ArtifactBuilderFactory getArtifactBuilderFactory() {
        return this.artifactBuilderFactory;
    }

    public void setArtifactBuilderFactory(@Nullable SAML2ArtifactBuilderFactory factory) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)((Object)this));
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)((Object)this));
        this.artifactBuilderFactory = factory;
    }

    @NonnullAfterInit
    public SOAPClient getSOAPClient() {
        return this.soapClient;
    }

    public void setSOAPClient(@Nonnull SOAPClient client) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)((Object)this));
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)((Object)this));
        this.soapClient = client;
    }

    @Nullable
    public String getSOAPPipelineName() {
        return this.soapPipelineName;
    }

    public void setSOAPPipelineName(@Nullable String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)((Object)this));
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)((Object)this));
        this.soapPipelineName = StringSupport.trimOrNull(name);
    }

    @Nullable
    public String getSOAPClientSecurityConfigurationProfileId() {
        return this.soapClientSecurityConfigurationProfileId;
    }

    @Nonnull
    public void setSOAPClientSecurityConfigurationProfileId(@Nullable String profileId) {
        this.soapClientSecurityConfigurationProfileId = StringSupport.trimOrNull(profileId);
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    }

    @Nullable
    public BindingDescriptor getBindingDescriptor() {
        return this.bindingDescriptor;
    }

    public void setBindingDescriptor(@Nullable BindingDescriptor descriptor) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)((Object)this));
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)((Object)this));
        this.bindingDescriptor = descriptor;
    }

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        HttpServletRequest request = this.getHttpServletRequest();
        String relayState = StringSupport.trim(request.getParameter("RelayState"));
        this.log.debug("Decoded SAML relay state of: {}", (Object)relayState);
        SAMLBindingSupport.setRelayState(messageContext, relayState);
        this.processArtifact(messageContext, request);
        this.populateBindingContext(messageContext);
        this.setMessageContext(messageContext);
    }

    private void processArtifact(MessageContext messageContext, HttpServletRequest request) throws MessageDecodingException {
        String encodedArtifact = StringSupport.trimOrNull(request.getParameter("SAMLart"));
        if (encodedArtifact == null) {
            this.log.error("URL SAMLart parameter was missing or did not contain a value");
            throw new MessageDecodingException("URL SAMLart parameter was missing or did not contain a value");
        }
        try {
            SAML2Artifact artifact = this.parseArtifact(encodedArtifact);
            RoleDescriptor peerRoleDescriptor = this.resolvePeerRoleDescriptor(artifact);
            if (peerRoleDescriptor == null) {
                throw new MessageDecodingException("Failed to resolve peer RoleDescriptor based on inbound artifact");
            }
            ArtifactResolutionService ars = this.resolveArtifactEndpoint(artifact, peerRoleDescriptor);
            SAMLObject inboundMessage = this.dereferenceArtifact(artifact, peerRoleDescriptor, ars);
            messageContext.setMessage((Object)inboundMessage);
        }
        catch (MessageDecodingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageDecodingException("Fatal error decoding or resolving inbound artifact", e);
        }
    }

    @Nonnull
    private SAMLObject dereferenceArtifact(@Nonnull SAML2Artifact artifact, @Nonnull RoleDescriptor peerRoleDescriptor, @Nonnull ArtifactResolutionService ars) throws MessageDecodingException {
        try {
            String selfEntityID = this.resolveSelfEntityID(peerRoleDescriptor);
            InOutOperationContext opContext = new SAMLSOAPClientContextBuilder().setOutboundMessage(this.buildArtifactResolveRequestMessage(artifact, ars.getLocation(), peerRoleDescriptor, selfEntityID)).setProtocol("urn:oasis:names:tc:SAML:2.0:protocol").setPipelineName(this.getSOAPPipelineName()).setSecurityConfigurationProfileId(this.getSOAPClientSecurityConfigurationProfileId()).setPeerRoleDescriptor(peerRoleDescriptor).setSelfEntityID(selfEntityID).build();
            this.log.trace("Executing ArtifactResolve over SOAP 1.1 binding to endpoint: {}", (Object)ars.getLocation());
            this.soapClient.send(ars.getLocation(), opContext);
            Object response = opContext.getInboundMessageContext().getMessage();
            if (response instanceof ArtifactResponse) {
                return this.validateAndExtractResponseMessage((ArtifactResponse)response);
            }
            throw new MessageDecodingException("SOAP message payload was not an instance of ArtifactResponse: " + response.getClass().getName());
        }
        catch (EncodingException | MessageException | SecurityException | SOAPException e) {
            throw new MessageDecodingException("Error dereferencing artifact", (Exception)e);
        }
    }

    @Nonnull
    private SAMLObject validateAndExtractResponseMessage(@Nonnull ArtifactResponse artifactResponse) throws MessageDecodingException {
        if (artifactResponse.getStatus() == null || artifactResponse.getStatus().getStatusCode() == null || artifactResponse.getStatus().getStatusCode().getValue() == null) {
            throw new MessageDecodingException("ArtifactResponse included no StatusCode, could not validate");
        }
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(artifactResponse.getStatus().getStatusCode().getValue())) {
            throw new MessageDecodingException("ArtifactResponse carried non-success StatusCode: " + artifactResponse.getStatus().getStatusCode().getValue());
        }
        if (artifactResponse.getMessage() == null) {
            throw new MessageDecodingException("ArtifactResponse carried an empty message payload");
        }
        return artifactResponse.getMessage();
    }

    @Nonnull
    private ArtifactResolve buildArtifactResolveRequestMessage(@Nonnull SAML2Artifact artifact, @Nonnull String endpoint, @Nonnull RoleDescriptor peerRoleDescriptor, @Nonnull String selfEntityID) throws EncodingException {
        ArtifactResolve request = (ArtifactResolve)XMLObjectSupport.buildXMLObject(ArtifactResolve.DEFAULT_ELEMENT_NAME);
        Artifact requestArtifact = (Artifact)XMLObjectSupport.buildXMLObject(Artifact.DEFAULT_ELEMENT_NAME);
        requestArtifact.setValue(Base64Support.encode(artifact.getArtifactBytes(), false));
        request.setArtifact(requestArtifact);
        request.setID(this.idStrategy.generateIdentifier(true));
        request.setDestination(endpoint);
        request.setIssueInstant(Instant.now());
        request.setIssuer(this.buildIssuer(selfEntityID));
        return request;
    }

    @Nonnull
    private String resolveSelfEntityID(@Nonnull RoleDescriptor peerRoleDescriptor) throws MessageDecodingException {
        CriteriaSet criteria = new CriteriaSet(new RoleDescriptorCriterion(peerRoleDescriptor));
        try {
            String selfEntityID = this.getSelfEntityIDResolver().resolveSingle(criteria);
            if (selfEntityID == null) {
                throw new MessageDecodingException("Unable to resolve self entityID from peer RoleDescriptor");
            }
            return selfEntityID;
        }
        catch (ResolverException e) {
            throw new MessageDecodingException("Fatal error resolving self entityID from peer RoleDescriptor", (Exception)e);
        }
    }

    @Nonnull
    private Issuer buildIssuer(@Nonnull String selfEntityID) {
        Issuer issuer = (Issuer)XMLObjectSupport.buildXMLObject(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(selfEntityID);
        return issuer;
    }

    @Nonnull
    private ArtifactResolutionService resolveArtifactEndpoint(@Nonnull SAML2Artifact artifact, @Nonnull RoleDescriptor peerRoleDescriptor) throws MessageDecodingException {
        RoleDescriptorCriterion roleDescriptorCriterion = new RoleDescriptorCriterion(peerRoleDescriptor);
        ArtifactResolutionService arsTemplate = (ArtifactResolutionService)XMLObjectSupport.buildXMLObject(ArtifactResolutionService.DEFAULT_ELEMENT_NAME);
        arsTemplate.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        if (artifact instanceof SAMLSourceLocationArtifact) {
            arsTemplate.setLocation(((SAMLSourceLocationArtifact)((Object)artifact)).getSourceLocation());
        }
        Integer endpointIndex = SAMLBindingSupport.convertSAML2ArtifactEndpointIndex(artifact.getEndpointIndex());
        arsTemplate.setIndex(endpointIndex);
        EndpointCriterion<ArtifactResolutionService> endpointCriterion = new EndpointCriterion<ArtifactResolutionService>(arsTemplate, false);
        CriteriaSet criteriaSet = new CriteriaSet(roleDescriptorCriterion, endpointCriterion);
        try {
            ArtifactResolutionService ars = (ArtifactResolutionService)this.artifactEndpointResolver.resolveSingle(criteriaSet);
            if (ars != null) {
                return ars;
            }
            throw new MessageDecodingException("Unable to resolve ArtifactResolutionService endpoint");
        }
        catch (ResolverException e) {
            throw new MessageDecodingException("Unable to resolve ArtifactResolutionService endpoint");
        }
    }

    @Nonnull
    private RoleDescriptor resolvePeerRoleDescriptor(@Nonnull SAML2Artifact artifact) throws MessageDecodingException {
        CriteriaSet criteriaSet = new CriteriaSet(new ArtifactCriterion(artifact), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol"), new EntityRoleCriterion(this.getPeerEntityRole()));
        try {
            RoleDescriptor rd = (RoleDescriptor)this.roleDescriptorResolver.resolveSingle(criteriaSet);
            if (rd == null) {
                throw new MessageDecodingException("Unable to resolve peer RoleDescriptor from supplied artifact");
            }
            return rd;
        }
        catch (ResolverException e) {
            throw new MessageDecodingException("Error resolving peer entity RoleDescriptor", (Exception)e);
        }
    }

    @Nonnull
    private SAML2Artifact parseArtifact(@Nonnull String encodedArtifact) throws MessageDecodingException {
        try {
            SAML2Artifact artifact = this.artifactBuilderFactory.buildArtifact(encodedArtifact);
            if (artifact == null) {
                throw new MessageDecodingException("Could not build SAML2Artifact instance from encoded artifact");
            }
            return artifact;
        }
        catch (DecodingException e) {
            throw new MessageDecodingException("Could not base64 decode SAML2Artifact instance from encoded artifact", (Exception)e);
        }
    }

    protected void populateBindingContext(MessageContext messageContext) {
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class, true);
        bindingContext.setBindingUri(this.getBindingURI());
        bindingContext.setBindingDescriptor(this.bindingDescriptor);
        bindingContext.setHasBindingSignature(false);
        bindingContext.setIntendedDestinationEndpointURIRequired(false);
    }
}

