/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.persist;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import network.oxalis.ng.api.evidence.EvidenceFactory;
import network.oxalis.ng.api.inbound.InboundMetadata;
import network.oxalis.ng.api.lang.EvidenceException;
import network.oxalis.ng.api.model.TransmissionIdentifier;
import network.oxalis.ng.api.persist.PersisterHandler;
import network.oxalis.ng.api.transmission.TransmissionResult;
import network.oxalis.ng.api.util.Type;
import network.oxalis.ng.commons.filesystem.FileUtils;
import network.oxalis.ng.commons.persist.PersisterUtils;
import network.oxalis.vefa.peppol.common.model.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Type(value={"temp"})
public class TempPersister
implements PersisterHandler {
    private static final Logger log = LoggerFactory.getLogger(TempPersister.class);
    private final EvidenceFactory evidenceFactory;
    private final Path folder;

    @Inject
    public TempPersister(EvidenceFactory evidenceFactory) throws IOException {
        this.evidenceFactory = evidenceFactory;
        this.folder = Files.createTempDirectory("oxalis-inbound", new FileAttribute[0]);
    }

    public Path persist(TransmissionIdentifier transmissionIdentifier, Header header, InputStream inputStream) throws IOException {
        Path path = PersisterUtils.createArtifactFolders(this.folder, header).resolve(String.format("%s.xml", FileUtils.filterString(transmissionIdentifier.getIdentifier())));
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        return path;
    }

    public void persist(InboundMetadata inboundMetadata, Path payloadPath) throws IOException {
        Path path = PersisterUtils.createArtifactFolders(this.folder, inboundMetadata.getHeader()).resolve(String.format("%s.evidence.dat", FileUtils.filterString(inboundMetadata.getTransmissionIdentifier().getIdentifier())));
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            this.evidenceFactory.write(outputStream, (TransmissionResult)inboundMetadata);
        }
        catch (EvidenceException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void persist(TransmissionIdentifier transmissionIdentifier, Header header, Path payloadPath, Exception exception) {
        try {
            if (Files.exists(payloadPath, new LinkOption[0])) {
                Files.delete(payloadPath);
            }
        }
        catch (IOException e) {
            log.warn("Unable to delete temp file: {}", (Object)payloadPath, (Object)e);
        }
    }
}

