/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.as4.common;

import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.security.Security;
import network.oxalis.ng.api.header.HeaderParser;
import network.oxalis.ng.api.settings.Settings;
import network.oxalis.ng.as4.api.MessageIdGenerator;
import network.oxalis.ng.as4.common.DefaultMessageIdGenerator;
import network.oxalis.ng.as4.common.DummyHeaderParser;
import network.oxalis.ng.as4.common.MerlinProvider;
import network.oxalis.ng.as4.config.As4Conf;
import network.oxalis.ng.as4.outbound.ActionProvider;
import network.oxalis.ng.as4.outbound.DefaultActionProvider;
import network.oxalis.ng.as4.util.As4MessageFactory;
import network.oxalis.ng.as4.util.OxalisAlgorithmSuiteLoader;
import network.oxalis.ng.as4.util.PolicyService;
import network.oxalis.ng.as4.util.TransmissionRequestUtil;
import network.oxalis.ng.commons.guice.ImplLoader;
import network.oxalis.ng.commons.guice.OxalisModule;
import network.oxalis.vefa.peppol.mode.Mode;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class As4CommonModule
extends OxalisModule {
    private static final Logger log = LoggerFactory.getLogger(As4CommonModule.class);

    protected void configure() {
        this.bindTyped(MessageIdGenerator.class, DefaultMessageIdGenerator.class);
        this.bindTyped(HeaderParser.class, DummyHeaderParser.class);
        this.bind(As4MessageFactory.class);
        this.bindSettings(As4Conf.class);
        this.bind(MerlinProvider.class);
        Bus bus = BusFactory.newInstance().createBus();
        bus.setProperty("org.apache.cxf.transports.http2.enabled", (Object)true);
        new OxalisAlgorithmSuiteLoader(bus);
        BusFactory.setThreadDefaultBus((Bus)bus);
        Security.setProperty("jdk.security.provider.preferred", "AES/GCM/NoPadding:BC");
        WSSConfig.init();
    }

    @Provides
    @Singleton
    public MessageIdGenerator getMessageIdGenerator(Injector injector, Settings<As4Conf> settings) {
        return (MessageIdGenerator)ImplLoader.get((Injector)injector, MessageIdGenerator.class, settings, (Object)((Object)As4Conf.MSGID_GENERATOR));
    }

    @Provides
    @Singleton
    public PolicyService getPolicyService(Mode mode, Settings<As4Conf> settings, ActionProvider actionProvider) {
        String type = settings.getString((Object)As4Conf.TYPE);
        if ("PRODUCTION".equals(mode.getIdentifier()) && !"peppol".equals(type)) {
            throw new IllegalStateException("oxalis.as4.type has to be peppol in PRODUCTION!");
        }
        if ("cef-connectivity".equalsIgnoreCase(type)) {
            return new PolicyService(actionProvider){

                @Override
                protected String getDefaultPolicy() {
                    return "/eDeliveryAS4Policy.xml";
                }
            };
        }
        if ("cef-conformance".equalsIgnoreCase(type)) {
            return new PolicyService(actionProvider){

                @Override
                protected String getPolicyClasspath(String action, String service) {
                    log.debug("Service = {}, Action = {}", (Object)service, (Object)action);
                    if ("SRV_ONEWAY_SIGNONLY".equals(service) && "busdox-docid-qns::ACT_ONEWAY_SIGNONLY".equals(action)) {
                        return "/signOnly.xml";
                    }
                    return this.getDefaultPolicy();
                }

                @Override
                protected String getDefaultPolicy() {
                    return "/eDeliveryAS4Policy.xml";
                }
            };
        }
        return new PolicyService(actionProvider);
    }

    @Provides
    @Singleton
    public ActionProvider getActionProvider(Settings<As4Conf> settings) {
        String type = settings.getString((Object)As4Conf.TYPE);
        if ("cef-connectivity".equalsIgnoreCase(type)) {
            return p -> {
                String action = TransmissionRequestUtil.translateDocumentTypeToAction(p);
                if (action.startsWith("connectivity::cef##connectivity::")) {
                    return action.replaceFirst("connectivity::cef##connectivity::", "");
                }
                return action;
            };
        }
        if ("cef-conformance".equalsIgnoreCase(type)) {
            return p -> {
                if ("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/test".equals(p.getIdentifier())) {
                    return "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/test";
                }
                return TransmissionRequestUtil.translateDocumentTypeToAction(p);
            };
        }
        return new DefaultActionProvider();
    }
}

