/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.certvalidator;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import network.oxalis.commons.certvalidator.ValidatorGroup;
import network.oxalis.commons.certvalidator.api.CertificateBucket;
import network.oxalis.commons.certvalidator.api.CertificateValidationException;
import network.oxalis.commons.certvalidator.api.ErrorHandler;
import network.oxalis.commons.certvalidator.api.Order;
import network.oxalis.commons.certvalidator.api.ValidatorRecipeParser;
import network.oxalis.commons.certvalidator.api.ValidatorRule;
import network.oxalis.commons.certvalidator.api.ValidatorRuleParser;
import network.oxalis.commons.certvalidator.jaxb.BlacklistType;
import network.oxalis.commons.certvalidator.jaxb.CachedType;
import network.oxalis.commons.certvalidator.jaxb.ChainType;
import network.oxalis.commons.certvalidator.jaxb.HandleErrorType;
import network.oxalis.commons.certvalidator.jaxb.JunctionEnum;
import network.oxalis.commons.certvalidator.jaxb.JunctionType;
import network.oxalis.commons.certvalidator.jaxb.OCSPType;
import network.oxalis.commons.certvalidator.jaxb.TryType;
import network.oxalis.commons.certvalidator.jaxb.ValidatorRecipe;
import network.oxalis.commons.certvalidator.jaxb.ValidatorType;
import network.oxalis.commons.certvalidator.jaxb.WhitelistType;
import network.oxalis.commons.certvalidator.lang.ValidatorParsingException;
import network.oxalis.commons.certvalidator.rule.BlacklistRule;
import network.oxalis.commons.certvalidator.rule.ChainRule;
import network.oxalis.commons.certvalidator.rule.HandleErrorRule;
import network.oxalis.commons.certvalidator.rule.OCSPRule;
import network.oxalis.commons.certvalidator.rule.WhitelistRule;
import network.oxalis.commons.certvalidator.structure.Junction;
import network.oxalis.commons.certvalidator.util.CachedValidatorRule;
import network.oxalis.pkix.ocsp.OcspClient;
import network.oxalis.pkix.ocsp.api.OcspFetcher;
import network.oxalis.pkix.ocsp.builder.Builder;

class ValidatorLoaderParser {
    private static JAXBContext jaxbContext;
    private static List<ValidatorRecipeParser> recipeParser;
    private static List<ValidatorRuleParser> ruleParsers;

    ValidatorLoaderParser() {
    }

    public static ValidatorGroup parse(InputStream inputStream, Map<String, Object> objectStorage) throws ValidatorParsingException {
        try {
            ValidatorRecipe recipe = (ValidatorRecipe)jaxbContext.createUnmarshaller().unmarshal((Source)new StreamSource(inputStream), ValidatorRecipe.class).getValue();
            for (ValidatorRecipeParser parser : recipeParser) {
                parser.parse(recipe, objectStorage);
            }
            HashMap<String, ValidatorRule> rulesMap = new HashMap<String, ValidatorRule>();
            for (ValidatorType validatorType : recipe.getValidator()) {
                ValidatorRule validatorRule = ValidatorLoaderParser.parse(validatorType.getBlacklistOrCachedOrChain(), objectStorage, JunctionEnum.AND);
                if (validatorType.getTimeout() != null) {
                    validatorRule = new CachedValidatorRule(validatorRule, validatorType.getTimeout());
                }
                String name = validatorType.getName() == null ? "default" : validatorType.getName();
                rulesMap.put(name, validatorRule);
                objectStorage.put(String.format("#validator::%s", name), validatorRule);
            }
            return new ValidatorGroup(rulesMap, recipe.getName(), recipe.getVersion());
        }
        catch (JAXBException | CertificateValidationException e) {
            throw new ValidatorParsingException(e.getMessage(), e);
        }
    }

    private static ValidatorRule parse(List<Object> rules, Map<String, Object> objectStorage, JunctionEnum junctionEnum) throws CertificateValidationException {
        ArrayList<ValidatorRule> ruleList = new ArrayList<ValidatorRule>();
        for (Object rule : rules) {
            ruleList.add(ValidatorLoaderParser.parse(rule, objectStorage));
        }
        if (junctionEnum == JunctionEnum.AND) {
            return Junction.and(ruleList.toArray(new ValidatorRule[ruleList.size()]));
        }
        if (junctionEnum == JunctionEnum.OR) {
            return Junction.or(ruleList.toArray(new ValidatorRule[ruleList.size()]));
        }
        return Junction.xor(ruleList.toArray(new ValidatorRule[ruleList.size()]));
    }

    private static ValidatorRule parse(Object rule, Map<String, Object> objectStorage) throws CertificateValidationException {
        if (rule instanceof BlacklistType) {
            return ValidatorLoaderParser.parse((BlacklistType)rule, objectStorage);
        }
        if (rule instanceof CachedType) {
            return ValidatorLoaderParser.parse((CachedType)rule, objectStorage);
        }
        if (rule instanceof ChainType) {
            return ValidatorLoaderParser.parse((ChainType)rule, objectStorage);
        }
        if (rule instanceof JunctionType) {
            return ValidatorLoaderParser.parse((JunctionType)rule, objectStorage);
        }
        if (rule instanceof OCSPType) {
            return ValidatorLoaderParser.parse((OCSPType)rule, objectStorage);
        }
        if (rule instanceof HandleErrorType) {
            return ValidatorLoaderParser.parse((HandleErrorType)rule, objectStorage);
        }
        if (rule instanceof TryType) {
            return ValidatorLoaderParser.parse((TryType)rule, objectStorage);
        }
        if (rule instanceof WhitelistType) {
            return ValidatorLoaderParser.parse((WhitelistType)rule, objectStorage);
        }
        for (ValidatorRuleParser parser : ruleParsers) {
            if (!parser.supports(rule.getClass())) continue;
            return parser.parse(rule, objectStorage);
        }
        throw new ValidatorParsingException(String.format("Unable to parse '%s'", rule));
    }

    private static ValidatorRule parse(BlacklistType rule, Map<String, Object> objectStorage) {
        return new BlacklistRule(ValidatorLoaderParser.getBucket(rule.getValue(), objectStorage));
    }

    private static ValidatorRule parse(CachedType rule, Map<String, Object> objectStorage) throws CertificateValidationException {
        return new CachedValidatorRule(ValidatorLoaderParser.parse(rule.getBlacklistOrCachedOrChain(), objectStorage, JunctionEnum.AND), rule.getTimeout());
    }

    private static ValidatorRule parse(ChainType rule, Map<String, Object> objectStorage) {
        return new ChainRule(ValidatorLoaderParser.getBucket(rule.getRootBucketReference().getValue(), objectStorage), ValidatorLoaderParser.getBucket(rule.getIntermediateBucketReference().getValue(), objectStorage), rule.getPolicy().toArray(new String[rule.getPolicy().size()]));
    }

    private static ValidatorRule parse(HandleErrorType optionalType, Map<String, Object> objectStorage) throws CertificateValidationException {
        String handlerKey;
        ArrayList<ValidatorRule> validatorRules = new ArrayList<ValidatorRule>();
        for (Object o : optionalType.getBlacklistOrCachedOrChain()) {
            validatorRules.add(ValidatorLoaderParser.parse(o, objectStorage));
        }
        String string = handlerKey = optionalType.getHandler() != null ? optionalType.getHandler() : "#errorhandler";
        if (objectStorage.get(handlerKey) != null) {
            return new HandleErrorRule((ErrorHandler)objectStorage.get(handlerKey), validatorRules);
        }
        return new HandleErrorRule(validatorRules);
    }

    private static ValidatorRule parse(JunctionType junctionType, Map<String, Object> objectStorage) throws CertificateValidationException {
        return ValidatorLoaderParser.parse(junctionType.getBlacklistOrCachedOrChain(), objectStorage, junctionType.getType());
    }

    private static ValidatorRule parse(OCSPType ocspType, Map<String, Object> objectStorage) {
        Builder builder = OcspClient.builder();
        builder = builder.set(OcspClient.INTERMEDIATES, ValidatorLoaderParser.getBucket(ocspType.getIntermediateBucketReference().getValue(), objectStorage).asList());
        if (objectStorage.containsKey("ocsp_fetcher")) {
            builder = builder.set(OcspClient.FETCHER, (Object)((OcspFetcher)objectStorage.get("ocsp_fetcher")));
        }
        return new OCSPRule((OcspClient)builder.build());
    }

    private static ValidatorRule parse(TryType tryType, Map<String, Object> objectStorage) throws CertificateValidationException {
        for (Object rule : tryType.getBlacklistOrCachedOrChain()) {
            try {
                return ValidatorLoaderParser.parse(rule, objectStorage);
            }
            catch (Exception exception) {
            }
        }
        throw new CertificateValidationException("Unable to find valid rule in try.");
    }

    private static ValidatorRule parse(WhitelistType rule, Map<String, Object> objectStorage) throws CertificateValidationException {
        return new WhitelistRule(ValidatorLoaderParser.getBucket(rule.getValue(), objectStorage));
    }

    private static CertificateBucket getBucket(String name, Map<String, Object> objectStorage) {
        return (CertificateBucket)objectStorage.get(String.format("#bucket::%s", name));
    }

    public static <T> List<T> serviceLoader(Class<T> cls) {
        return StreamSupport.stream(ServiceLoader.load(cls).spliterator(), false).sorted((o1, o2) -> {
            int v1 = o1.getClass().isAnnotationPresent(Order.class) ? o1.getClass().getAnnotation(Order.class).value() : 0;
            int v2 = o2.getClass().isAnnotationPresent(Order.class) ? o2.getClass().getAnnotation(Order.class).value() : 0;
            return Integer.compare(v1, v2);
        }).collect(Collectors.toList());
    }

    static {
        recipeParser = ValidatorLoaderParser.serviceLoader(ValidatorRecipeParser.class);
        ruleParsers = ValidatorLoaderParser.serviceLoader(ValidatorRuleParser.class);
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ValidatorRecipe.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

