/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.settings;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.util.Types;
import com.typesafe.config.Config;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import network.oxalis.ng.api.settings.Path;
import network.oxalis.ng.api.settings.Settings;
import network.oxalis.ng.api.settings.Title;
import network.oxalis.ng.commons.guice.OxalisModule;
import network.oxalis.ng.commons.settings.TypesafeSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsBuilder<T>
implements Provider<Settings<T>> {
    private static final Logger log = LoggerFactory.getLogger(SettingsBuilder.class);
    private Config config;
    private final Map<T, String> settings = new HashMap<T, String>();
    private final String title;

    public static <T> SettingsBuilder<T> with(Binder binder, Class<T> cls) {
        SettingsBuilder<T> settingsBuilder = new SettingsBuilder<T>(cls.getAnnotation(Title.class).value());
        binder.skipSources(SettingsBuilder.class, OxalisModule.class).bind(Key.get(Types.newParameterizedType(Settings.class, new Type[]{cls}))).toProvider((Provider<?>)settingsBuilder).in(Singleton.class);
        binder.skipSources(SettingsBuilder.class, OxalisModule.class).requestInjection(settingsBuilder);
        for (T t2 : cls.getEnumConstants()) {
            settingsBuilder.add(t2);
        }
        return settingsBuilder;
    }

    private SettingsBuilder(String title) {
        this.title = title;
    }

    private void add(T key) {
        this.settings.put(key, TypesafeSettings.getField(key).getAnnotation(Path.class).value());
    }

    @Inject
    public void setConfig(Config config) {
        this.config = config;
        Object result = this.get();
        this.settings.keySet().stream().sorted().forEach(arg_0 -> this.lambda$setConfig$0((Settings)result, arg_0));
    }

    @Override
    public Settings<T> get() {
        return new TypesafeSettings<T>(this.config, this.settings);
    }

    private /* synthetic */ void lambda$setConfig$0(Settings result, Object key) {
        log.info("{} => {}: {}", this.title, key, result.toLogSafeString(key));
    }
}

