/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap.portability;

import java.nio.ByteBuffer;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.portability.Portability;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;

public class SerializerPortability<T>
implements Portability<T> {
    private final Serializer<T> serializer;

    public SerializerPortability(Serializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public ByteBuffer encode(T t2) {
        return this.serializer.serialize(t2);
    }

    @Override
    public T decode(ByteBuffer byteBuffer) {
        try {
            return this.serializer.read(byteBuffer);
        }
        catch (ClassNotFoundException e) {
            throw new SerializerException(e);
        }
    }

    @Override
    public boolean equals(Object o, ByteBuffer byteBuffer) {
        try {
            Object otherValue = o;
            return this.serializer.equals(otherValue, byteBuffer);
        }
        catch (ClassNotFoundException e) {
            throw new SerializerException(e);
        }
    }
}

