/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ehcache.xml.JaxbHelper;
import org.ehcache.xml.model.BaseCacheType;
import org.ehcache.xml.model.CacheEntryType;
import org.ehcache.xml.model.CacheLoaderWriterType;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.DiskStoreSettingsType;
import org.ehcache.xml.model.Expiry;
import org.ehcache.xml.model.Heap;
import org.ehcache.xml.model.ListenersConfig;
import org.ehcache.xml.model.ListenersType;
import org.ehcache.xml.model.ResourcesType;
import org.ehcache.xml.model.SizeOfEngineLimits;
import org.w3c.dom.Element;

public class CacheSpec
implements CacheTemplate {
    protected final List<BaseCacheType> sources;
    private final String id;

    public CacheSpec(String id, BaseCacheType ... sources) {
        this.id = id;
        this.sources = Arrays.asList(sources);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String keyType() {
        return this.key().map(CacheEntryType::getValue).orElseGet(() -> this.extract(source -> JaxbHelper.findDefaultValue(source, "keyType")).orElse(null));
    }

    @Override
    public String keySerializer() {
        return this.key().map(CacheEntryType::getSerializer).orElse(null);
    }

    @Override
    public String keyCopier() {
        return this.key().map(CacheEntryType::getCopier).orElse(null);
    }

    private Optional<CacheEntryType> key() {
        return this.extract(BaseCacheType::getKeyType);
    }

    @Override
    public String valueType() {
        return this.value().map(CacheEntryType::getValue).orElseGet(() -> this.extract(source -> JaxbHelper.findDefaultValue(source, "keyType")).orElse(null));
    }

    @Override
    public String valueSerializer() {
        return this.value().map(CacheEntryType::getSerializer).orElse(null);
    }

    @Override
    public String valueCopier() {
        return this.value().map(CacheEntryType::getCopier).orElse(null);
    }

    private Optional<CacheEntryType> value() {
        return this.extract(BaseCacheType::getValueType);
    }

    @Override
    public String evictionAdvisor() {
        return this.extract(BaseCacheType::getEvictionAdvisor).orElse(null);
    }

    @Override
    public Expiry expiry() {
        return this.extract(BaseCacheType::getExpiry).map(Expiry::new).orElse(null);
    }

    @Override
    public List<Element> getResources() {
        return this.extract(BaseCacheType::getResources).map(ResourcesType::getResource).orElse(Collections.emptyList());
    }

    @Override
    public String loaderWriter() {
        return this.extract(BaseCacheType::getLoaderWriter).map(CacheLoaderWriterType::getClazz).orElse(null);
    }

    @Override
    public String resilienceStrategy() {
        return this.extract(BaseCacheType::getResilience).orElse(null);
    }

    @Override
    public ListenersConfig listenersConfig() {
        ListenersType base = null;
        ArrayList<ListenersType> additionals = new ArrayList<ListenersType>();
        for (BaseCacheType source : this.sources) {
            if (source.getListeners() == null) continue;
            if (base == null) {
                base = source.getListeners();
                continue;
            }
            additionals.add(source.getListeners());
        }
        return base != null ? new ListenersConfig(base, additionals.toArray(new ListenersType[0])) : null;
    }

    @Override
    public Collection<Element> serviceConfigExtensions() {
        return this.sources.stream().flatMap(s2 -> s2.getServiceConfiguration().stream()).collect(Collectors.toMap(Element::getTagName, Function.identity(), (a, b) -> a)).values();
    }

    @Override
    public Heap getHeap() {
        return this.extract(BaseCacheType::getHeap).orElse(null);
    }

    @Override
    public CacheLoaderWriterType.WriteBehind writeBehind() {
        return this.extract(BaseCacheType::getLoaderWriter).map(CacheLoaderWriterType::getWriteBehind).orElse(null);
    }

    @Override
    public DiskStoreSettingsType diskStoreSettings() {
        return this.extract(BaseCacheType::getDiskStoreSettings).orElse(null);
    }

    @Override
    public SizeOfEngineLimits heapStoreSettings() {
        return this.extract(BaseCacheType::getHeapStoreSettings).map(SizeOfEngineLimits::new).orElse(null);
    }

    private <T> Optional<T> extract(Function<BaseCacheType, T> extractor) {
        return this.sources.stream().map(s2 -> Optional.ofNullable(extractor.apply((BaseCacheType)s2))).filter(Optional::isPresent).map(Optional::get).findFirst();
    }
}

