/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataFilterChain
implements MetadataFilter {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(MetadataFilterChain.class);
    @Nonnull
    @NonnullElements
    private List<MetadataFilter> filters = new ArrayList<MetadataFilter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final XMLObject filter(@Nullable XMLObject xmlObject, @Nonnull MetadataFilterContext context) throws FilterException {
        if (xmlObject == null) {
            return null;
        }
        List<MetadataFilter> list = this.filters;
        synchronized (list) {
            if (this.filters == null || this.filters.isEmpty()) {
                this.log.debug("No filters configured, nothing to do");
                return xmlObject;
            }
            XMLObject current = xmlObject;
            for (MetadataFilter filter : this.filters) {
                if (current == null) {
                    return null;
                }
                this.log.debug("Applying filter {}", (Object)filter.getClass().getName());
                current = filter.filter(current, context);
            }
            return current;
        }
    }

    @Nonnull
    @NonnullElements
    @Live
    public List<MetadataFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(@Nonnull @NonnullElements List<MetadataFilter> newFilters) {
        Constraint.isNotNull(newFilters, "Filter collection cannot be null");
        this.filters = new ArrayList<MetadataFilter>(List.copyOf(newFilters));
    }
}

