/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto.ec.curves;

import com.google.common.base.MoreObjects;
import java.security.spec.ECParameterSpec;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.security.crypto.ec.NamedCurve;

public class BasicNamedCurve
implements NamedCurve {
    @Nonnull
    private String name;
    @Nonnull
    private String oid;
    @Nonnull
    private ECParameterSpec params;

    public BasicNamedCurve(@Nonnull String objectIdentifier, @Nonnull String standardName, @Nonnull ECParameterSpec parameters) {
        this.oid = Constraint.isNotNull(StringSupport.trimOrNull(objectIdentifier), "Curve identifier was null");
        this.name = Constraint.isNotNull(StringSupport.trimOrNull(standardName), "Curve name was null");
        this.params = Constraint.isNotNull(parameters, "Curve parameters was null");
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ECParameterSpec getParameterSpec() {
        return this.params;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.getName()).add("OID", this.getObjectIdentifier()).toString();
    }
}

