/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.scripting.AbstractScriptEvaluator;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedBiFunction<T, U, V>
extends AbstractScriptEvaluator
implements BiFunction<T, U, V> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedBiFunction.class);
    @Nullable
    private Pair<Class<T>, Class<U>> inputTypes;

    protected ScriptedBiFunction(@Nonnull @ParameterName(name="theScript") @NotEmpty EvaluableScript theScript, @Nullable @ParameterName(name="extraInfo") @NotEmpty String extraInfo) {
        super(theScript);
        this.setLogPrefix("Scripted BiFunction from " + extraInfo + ":");
    }

    protected ScriptedBiFunction(@Nonnull @ParameterName(name="theScript") @NotEmpty EvaluableScript theScript) {
        super(theScript);
        this.setLogPrefix("Anonymous BiFunction:");
    }

    @Nullable
    public Pair<Class<T>, Class<U>> getInputTypes() {
        return this.inputTypes;
    }

    public void setInputTypes(@Nullable Pair<Class<T>, Class<U>> types) {
        this.inputTypes = types != null && types.getFirst() != null && types.getSecond() != null ? types : null;
    }

    @Override
    public void setOutputType(@Nullable Class<?> type) {
        super.setOutputType(type);
    }

    @Override
    public void setReturnOnError(@Nullable Object value) {
        super.setReturnOnError(value);
    }

    @Override
    @Nullable
    public V apply(@Nullable T first, @Nullable U second) {
        Pair<Class<T>, Class<U>> types = this.getInputTypes();
        if (null != types) {
            if (null != first && !types.getFirst().isInstance(first)) {
                this.log.error("{} Input of type {} was not of type {}", this.getLogPrefix(), first.getClass(), types.getFirst());
                return (V)this.getReturnOnError();
            }
            if (null != second && !types.getSecond().isInstance(second)) {
                this.log.error("{} Input of type {} was not of type {}", this.getLogPrefix(), second.getClass(), types.getSecond());
                return (V)this.getReturnOnError();
            }
        }
        return (V)this.evaluate(first, second);
    }

    @Override
    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        scriptContext.setAttribute("input1", input[0], 100);
        scriptContext.setAttribute("input2", input[1], 100);
    }

    public static <T, U, V> ScriptedBiFunction<T, U, V> resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript();
            script.setEngineName(engineName);
            script.setScript(is);
            script.initializeWithScriptException();
            ScriptedBiFunction<T, U, V> scriptedBiFunction = new ScriptedBiFunction<T, U, V>(script, resource.getDescription());
            return scriptedBiFunction;
        }
    }

    public static <T, U, V> ScriptedBiFunction<T, U, V> resourceScript(Resource resource) throws ScriptException, IOException {
        return ScriptedBiFunction.resourceScript("JavaScript", resource);
    }

    public static <T, U, V> ScriptedBiFunction<T, U, V> inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initializeWithScriptException();
        return new ScriptedBiFunction<T, U, V>(script, "Inline");
    }

    public static <T, U, V> ScriptedBiFunction<T, U, V> inlineScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript();
        script.setScript(scriptSource);
        script.initializeWithScriptException();
        return new ScriptedBiFunction<T, U, V>(script, "Inline");
    }
}

