/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.outbound.transmission;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Objects;
import network.oxalis.ng.api.outbound.TransmissionMessage;
import network.oxalis.ng.api.outbound.TransmissionRequest;
import network.oxalis.ng.api.tag.Tag;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import network.oxalis.vefa.peppol.common.model.Header;

class DefaultTransmissionRequest
implements TransmissionRequest,
Serializable {
    private static final long serialVersionUID = -4542158917465140099L;
    private final Tag tag;
    private final Endpoint endpoint;
    private final Header header;
    private final InputStream payload;

    public DefaultTransmissionRequest(Header header, InputStream inputStream, Endpoint endpoint, Tag tag) {
        this.tag = tag;
        this.endpoint = endpoint;
        this.header = header;
        this.payload = inputStream;
    }

    public DefaultTransmissionRequest(TransmissionMessage transmissionMessage, Endpoint endpoint) {
        this.endpoint = endpoint;
        this.tag = transmissionMessage.getTag();
        this.header = transmissionMessage.getHeader();
        this.payload = transmissionMessage.getPayload();
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Tag getTag() {
        return this.tag;
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public InputStream getPayload() {
        return this.payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTransmissionRequest that = (DefaultTransmissionRequest)o;
        return Objects.equals(this.tag, that.tag) && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.header, that.header) && Objects.equals(this.payload, that.payload);
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.endpoint, this.header, this.payload);
    }
}

