/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.outbound.transmission;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import io.opentelemetry.api.trace.Tracer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import network.oxalis.ng.api.header.HeaderParser;
import network.oxalis.ng.api.lang.OxalisContentException;
import network.oxalis.ng.api.lang.OxalisTransmissionException;
import network.oxalis.ng.api.lookup.LookupService;
import network.oxalis.ng.api.model.Direction;
import network.oxalis.ng.api.outbound.TransmissionRequest;
import network.oxalis.ng.api.tag.Tag;
import network.oxalis.ng.api.tag.TagGenerator;
import network.oxalis.ng.api.transformer.ContentDetector;
import network.oxalis.ng.commons.util.ClosableSpan;
import network.oxalis.ng.outbound.transmission.DefaultTransmissionRequest;
import network.oxalis.ng.sniffer.PeppolStandardBusinessHeader;
import network.oxalis.ng.sniffer.identifier.InstanceId;
import network.oxalis.ng.sniffer.sbdh.SbdhWrapper;
import network.oxalis.vefa.peppol.common.model.C1CountryIdentifier;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransmissionRequestBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransmissionRequestBuilder.class);
    private final ContentDetector contentDetector;
    private final LookupService lookupService;
    private final TagGenerator tagGenerator;
    private final HeaderParser headerParser;
    private final Tracer tracer;
    private boolean allowOverride;
    private byte[] payload;
    private Endpoint endpoint;
    private Tag tag = Tag.NONE;
    private PeppolStandardBusinessHeader suppliedHeaderFields = new PeppolStandardBusinessHeader();
    private PeppolStandardBusinessHeader effectiveStandardBusinessHeader;

    @Inject
    public TransmissionRequestBuilder(ContentDetector contentDetector, LookupService lookupService, TagGenerator tagGenerator, HeaderParser headerParser, Tracer tracer) {
        this.contentDetector = contentDetector;
        this.lookupService = lookupService;
        this.tagGenerator = tagGenerator;
        this.headerParser = headerParser;
        this.tracer = tracer;
    }

    public void reset() {
        this.suppliedHeaderFields = new PeppolStandardBusinessHeader();
        this.effectiveStandardBusinessHeader = null;
    }

    public TransmissionRequestBuilder payLoad(InputStream inputStream) {
        this.savePayLoad(inputStream);
        return this;
    }

    public TransmissionRequestBuilder overrideAs4Endpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public TransmissionRequestBuilder receiver(ParticipantIdentifier receiverId) {
        this.suppliedHeaderFields.setRecipientId(receiverId);
        return this;
    }

    public TransmissionRequestBuilder sender(ParticipantIdentifier senderId) {
        this.suppliedHeaderFields.setSenderId(senderId);
        return this;
    }

    public TransmissionRequestBuilder documentType(DocumentTypeIdentifier documentTypeIdentifier) {
        this.suppliedHeaderFields.setDocumentTypeIdentifier(documentTypeIdentifier);
        return this;
    }

    public TransmissionRequestBuilder processType(ProcessIdentifier processTypeId) {
        this.suppliedHeaderFields.setProfileTypeIdentifier(processTypeId);
        return this;
    }

    public TransmissionRequestBuilder c1CountryIdentifier(C1CountryIdentifier c1CountryIdentifier) {
        this.suppliedHeaderFields.setC1CountryIdentifier(c1CountryIdentifier);
        return this;
    }

    public TransmissionRequestBuilder instanceId(InstanceId instanceId) {
        this.suppliedHeaderFields.setInstanceId(instanceId);
        return this;
    }

    public TransmissionRequestBuilder tag(Tag tag) {
        this.tag = tag;
        return this;
    }

    public TransmissionRequest build() throws OxalisTransmissionException, OxalisContentException {
        try (ClosableSpan ignored = this.tracer.spanBuilder("build").startSpan()::end;){
            if (this.payload.length < 2) {
                throw new OxalisTransmissionException("You have forgotten to provide payload");
            }
            PeppolStandardBusinessHeader optionalParsedSbdh = null;
            try {
                optionalParsedSbdh = new PeppolStandardBusinessHeader(this.headerParser.parse(new ByteArrayInputStream(this.payload)));
            }
            catch (OxalisContentException oxalisContentException) {
                // empty catch block
            }
            this.effectiveStandardBusinessHeader = this.makeEffectiveSbdh(Optional.ofNullable(optionalParsedSbdh), this.suppliedHeaderFields);
            if (this.isEndpointSuppliedByCaller() && this.isOverrideAllowed()) {
                log.warn("Endpoint was set by caller not retrieved from SMP, make sure this is intended behaviour.");
            } else {
                Endpoint endpoint = this.lookupService.lookup(this.effectiveStandardBusinessHeader.toVefa());
                if (this.isEndpointSuppliedByCaller() && !this.endpoint.equals(endpoint)) {
                    throw new IllegalStateException("You are not allowed to override the EndpointAddress from SMP.");
                }
                this.endpoint = endpoint;
            }
            if (optionalParsedSbdh == null) {
                this.payload = this.wrapPayLoadWithSBDH(new ByteArrayInputStream(this.payload), this.effectiveStandardBusinessHeader);
            }
            DefaultTransmissionRequest defaultTransmissionRequest = new DefaultTransmissionRequest(this.getEffectiveStandardBusinessHeader().toVefa(), this.getPayload(), this.getEndpoint(), this.tagGenerator.generate(Direction.OUT, this.tag));
            return defaultTransmissionRequest;
        }
    }

    PeppolStandardBusinessHeader makeEffectiveSbdh(Optional<PeppolStandardBusinessHeader> optionalParsedSbdh, PeppolStandardBusinessHeader peppolSbdhSuppliedByCaller) throws OxalisContentException {
        PeppolStandardBusinessHeader effectiveSbdh;
        if (this.isOverrideAllowed()) {
            if (peppolSbdhSuppliedByCaller.isComplete()) {
                effectiveSbdh = peppolSbdhSuppliedByCaller;
            } else {
                PeppolStandardBusinessHeader parsedPeppolStandardBusinessHeader = this.parsePayLoadAndDeduceSbdh(optionalParsedSbdh);
                effectiveSbdh = this.createEffectiveHeader(parsedPeppolStandardBusinessHeader, peppolSbdhSuppliedByCaller);
            }
        } else {
            PeppolStandardBusinessHeader parsedPeppolStandardBusinessHeader = this.parsePayLoadAndDeduceSbdh(optionalParsedSbdh);
            List<String> overriddenHeaders = this.findRestricedHeadersThatWillBeOverridden(parsedPeppolStandardBusinessHeader, peppolSbdhSuppliedByCaller);
            if (overriddenHeaders.isEmpty()) {
                effectiveSbdh = this.createEffectiveHeader(parsedPeppolStandardBusinessHeader, peppolSbdhSuppliedByCaller);
            } else {
                throw new IllegalStateException("Your are not allowed to override " + Arrays.toString(overriddenHeaders.toArray()) + " in production mode, makes sure headers match the ones in the document.");
            }
        }
        if (!effectiveSbdh.isComplete()) {
            throw new IllegalStateException("TransmissionRequest can not be built, missing " + Arrays.toString(effectiveSbdh.listMissingProperties().toArray()) + " metadata.");
        }
        return effectiveSbdh;
    }

    private PeppolStandardBusinessHeader parsePayLoadAndDeduceSbdh(Optional<PeppolStandardBusinessHeader> optionallyParsedSbdh) throws OxalisContentException {
        if (optionallyParsedSbdh.isPresent()) {
            return optionallyParsedSbdh.get();
        }
        return new PeppolStandardBusinessHeader(this.contentDetector.parse(new ByteArrayInputStream(this.payload)));
    }

    protected PeppolStandardBusinessHeader createEffectiveHeader(PeppolStandardBusinessHeader parsed, PeppolStandardBusinessHeader supplied) {
        PeppolStandardBusinessHeader mergedHeaders = new PeppolStandardBusinessHeader(parsed);
        if (supplied.getSenderId() != null) {
            mergedHeaders.setSenderId(supplied.getSenderId());
        }
        if (supplied.getRecipientId() != null) {
            mergedHeaders.setRecipientId(supplied.getRecipientId());
        }
        if (supplied.getDocumentTypeIdentifier() != null) {
            mergedHeaders.setDocumentTypeIdentifier(supplied.getDocumentTypeIdentifier());
        }
        if (supplied.getProfileTypeIdentifier() != null) {
            mergedHeaders.setProfileTypeIdentifier(supplied.getProfileTypeIdentifier());
        }
        if (supplied.getC1CountryIdentifier() != null) {
            mergedHeaders.setC1CountryIdentifier(supplied.getC1CountryIdentifier());
        }
        if (supplied.getInstanceId() != null) {
            mergedHeaders.setInstanceId(supplied.getInstanceId());
        } else {
            mergedHeaders.setInstanceId(new InstanceId());
        }
        if (supplied.getCreationDateAndTime() != null) {
            mergedHeaders.setCreationDateAndTime(supplied.getCreationDateAndTime());
        }
        return mergedHeaders;
    }

    protected List<String> findRestricedHeadersThatWillBeOverridden(PeppolStandardBusinessHeader parsed, PeppolStandardBusinessHeader supplied) {
        ArrayList<String> headers = new ArrayList<String>();
        if (parsed.getSenderId() != null && supplied.getSenderId() != null && !supplied.getSenderId().equals(parsed.getSenderId())) {
            headers.add("SenderId");
        }
        if (parsed.getRecipientId() != null && supplied.getRecipientId() != null && !supplied.getRecipientId().equals(parsed.getRecipientId())) {
            headers.add("RecipientId");
        }
        if (parsed.getDocumentTypeIdentifier() != null && supplied.getDocumentTypeIdentifier() != null && !supplied.getDocumentTypeIdentifier().equals(parsed.getDocumentTypeIdentifier())) {
            headers.add("DocumentTypeIdentifier");
        }
        if (parsed.getProfileTypeIdentifier() != null && supplied.getProfileTypeIdentifier() != null && !supplied.getProfileTypeIdentifier().equals(parsed.getProfileTypeIdentifier())) {
            headers.add("ProfileTypeIdentifier");
        }
        return headers;
    }

    protected PeppolStandardBusinessHeader getEffectiveStandardBusinessHeader() {
        return this.effectiveStandardBusinessHeader;
    }

    protected void savePayLoad(InputStream inputStream) {
        try {
            this.payload = ByteStreams.toByteArray(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to save the payload: " + e.getMessage(), e);
        }
    }

    protected InputStream getPayload() {
        return new ByteArrayInputStream(this.payload);
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public boolean isOverrideAllowed() {
        return this.allowOverride;
    }

    private boolean isEndpointSuppliedByCaller() {
        return this.endpoint != null;
    }

    private byte[] wrapPayLoadWithSBDH(ByteArrayInputStream byteArrayInputStream, PeppolStandardBusinessHeader effectiveStandardBusinessHeader) {
        SbdhWrapper sbdhWrapper = new SbdhWrapper();
        return sbdhWrapper.wrap(byteArrayInputStream, effectiveStandardBusinessHeader.toVefa());
    }

    public void setTransmissionBuilderOverride(boolean transmissionBuilderOverride) {
        this.allowOverride = transmissionBuilderOverride;
    }
}

