/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.fetcher;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.List;
import network.oxalis.vefa.peppol.lookup.api.FetcherResponse;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.lookup.fetcher.AbstractFetcher;
import network.oxalis.vefa.peppol.mode.Mode;

public class UrlFetcher
extends AbstractFetcher {
    public UrlFetcher(Mode mode) {
        super(mode);
    }

    @Override
    public FetcherResponse fetch(List<URI> uriList) throws LookupException, FileNotFoundException {
        FetcherResponse fetcherResponse = null;
        Exception exceptionObj = null;
        if (uriList == null || uriList.isEmpty()) {
            throw new LookupException("Unable to lookup requested URL or SMP registration is not valid.");
        }
        for (URI uri : uriList) {
            try {
                fetcherResponse = this.fetchResponseFromValidUri(uri);
                if (fetcherResponse == null) continue;
                exceptionObj = null;
                break;
            }
            catch (FileNotFoundException | LookupException e) {
                exceptionObj = e;
            }
        }
        if (exceptionObj instanceof FileNotFoundException) {
            throw new FileNotFoundException();
        }
        if (exceptionObj instanceof LookupException) {
            throw new LookupException(exceptionObj.getMessage(), exceptionObj);
        }
        return fetcherResponse;
    }

    private FetcherResponse fetchResponseFromValidUri(URI uri) throws LookupException, FileNotFoundException {
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)uri.toURL().openConnection();
            if (this.timeout >= Integer.MIN_VALUE && this.timeout <= Integer.MAX_VALUE) {
                urlConnection.setConnectTimeout((int)this.timeout);
                urlConnection.setReadTimeout((int)this.timeout);
            } else {
                urlConnection.setConnectTimeout(10000);
                urlConnection.setReadTimeout(10000);
            }
            if (urlConnection.getResponseCode() != 200) {
                return null;
            }
            return new FetcherResponse(new BufferedInputStream(urlConnection.getInputStream()), urlConnection.getHeaderField("X-SMP-Namespace"));
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(uri.toString());
        }
        catch (SocketException | SocketTimeoutException e) {
            throw new LookupException(String.format("Unable to fetch '%s'", uri), e);
        }
        catch (IOException e) {
            throw new LookupException(e.getMessage(), e);
        }
    }
}

